/***************************************************************************/
/*                                                                         */
/*                             G A M E . C P P                             */
/*                           Class Source Code                             */
/*                                                                         */
/*     Content : Game class source code                                    */
/*     Programmer : Eric Pietrocupo                                        */
/*     Starting Date : April 30th, 2002                                    */
/*                                                                         */
/***************************************************************************/

#include <general.h>
//#include <stdio.h>
//#include <stdlib.h>
//#include <time.h>
#include <allegro.h>
#include <string.h>
//#include <datafile.h>
//#include <datmacro.h>
//#include <system.h>
//#include <dbdata.h>
//#include <dbtag.h>
//#include <database.h>
//#include <dbobject.h>
#include <ddt.h>
#include <dbdef.h>
//#include <init.h>
//#include <menu.h>
//#include <option.h>
//#include <screen.h>
//#include <item.h>
//#include <armor.h>
//#include <weapon.h>
//#include <shield.h>
//#include <accesory.h>
//#include <expandbl.h>
//#include <list.h>
//#include <opponent.h>
//#include <charactr.h>
//#include <monster.h>
//#include <party.h>
//#include <player.h>
#include <game.h>
//#include <city.h>
//#include <maze.h>
//#include <adventur.h>
//#include <camp.h>
//#include <config.h>
//#include <draw.h>
//#include <dialog.h>
//#include <combat.h>



/*-------------------------------------------------------------------------*/
/*-                     Constructor & Destructor                          -*/
/*-------------------------------------------------------------------------*/

Game::Game ( void )
{
//   p_adventurefile = "";
   strcpy ( p_savegamefile, "" );
   strcpy ( p_password, "" );
   p_pass_protect = 0;
   p_difficulty = 0;
   p_levelup = 0;

   p_dblength = sizeof ( dbs_Game );
   p_dbtableID = DBTABLE_GAME;
}

Game::~Game ( void )
{

}


/*-------------------------------------------------------------------------*/
/*-                        Property Methods                               -*/
/*-------------------------------------------------------------------------*/

/*
s_Game_time Game::time ( void )
{
   return ( p_time );
}

s_Game_date Game::date ( void )
{
   return ( p_date );
}

void Game::admin_password ( string &str )
{

}
  */
/*string& Game::adventure ( void )
{
   return ( p_adventurefile );
}

const char* Game::cadventure ( void )
{
   return (  p_adventurefile.data() );
}

void Game::adventure ( string &str )
{
   p_adventurefile = str;
} */

/*string& Game::savegame ( void )
{
   return ( p_savegamefile );
} */

const char* Game::savegame ( void )
{
   return ( p_savegamefile );
}

void Game::savegame ( const char *str )
{
   strncpy ( p_savegamefile, str, 23 );
}
  
void Game::password ( const char *str )
{
   strcpy ( p_password, str );
}

tiny Game::difficulty ( void )
{
   return ( p_difficulty );
}
void Game::difficulty ( tiny value )
{
   p_difficulty = value;
}
tiny Game::levelup ( void )
{
   return ( p_levelup );
}

void Game::levelup ( tiny value )
{
   p_levelup = value;
}
void Game::protect ( void )
{
   p_pass_protect = true;
}
void Game::open ( void )
{
   p_pass_protect = false;
}
bool Game::pass_protect ( void )
{
   return ( p_pass_protect );
}

DBTag Game::adventure ( void )
{
   return p_adventure;
}

void Game::adventure ( DBTag value )
{
   p_adventure = value;
}


/*-------------------------------------------------------------------------*/
/*-                            Method                                     -*/
/*-------------------------------------------------------------------------*/

/*
void Game::inc_second ( tiny value )
{
   p_time.second = p_time.second + value;
   adjust_overflow ();
}

void Game::inc_minute ( tiny value )
{
   p_time.minute = p_time.minute + value;
   adjust_overflow ();
}

void Game::inc_hour ( tiny value )
{
   p_time.hour = p_time.hour + value;
   adjust_overflow ();
}

void Game::inc_day ( tiny value )
{
   p_date.day = p_date.day + value;
   adjust_overflow ();
}

bool Game::verify_admin_password ( string &str )
{

}
  */
bool Game::verify_password ( const char *str )
{
   if ( strcmp ( p_password, str ) == 0 )
      return ( true );
   else
      return ( false );
}

/*-------------------------------------------------------------------------*/
/*-                      Private Methods                                  -*/
/*-------------------------------------------------------------------------*/
/*
void Game::adjust_overflow ( void )
{
   while ( p_time.second >= 60 )
   {
      p_time.minute++;
      p_time.second = p_time.second - 60;
   }

   while ( p_time.minute >= 60 )
   {
      p_time.hour++;
      p_time.minute = p_time.minute - 60;
   }
   
   while ( p_time.second >= 24 )
   {
      p_date.day++;
      p_time.hour = p_time.hour - 24;
   }

   while ( p_date.day > 28 )
   {
      p_date.month++;
      p_date.day = p_date.day - 28;
   }

   while ( p_date.month > 12 )
   {
      p_date.year++;
      p_date.month = p_date.month - 12;
   }
}
  */


/*-------------------------------------------------------------------------*/
/*-                        Virtual Methods                                -*/
/*-------------------------------------------------------------------------*/

/*
DBTag Game::DBinsert ( void )
{
   dbs_Game tmpdat;
   DBTag tmptag;

   strncpy ( tmpdat.adventurefile, p_adventurefile, 12 );
   strncpy ( tmpdat.savegamefile, p_savegamefile, 12 );
   strncpy ( tmpdat.password, p_password, 10 );
   if ( p_pass_protect == true )
      tmpdat.pass_protect = 1;
   else
      tmpdat.pass_protect = 0;
   tmpdat.difficulty = p_difficulty;
   tmpdat.levelup = p_levelup;

   tmptag = db.insert ( DBTABLE_GAME,
      static_cast<void*>(&tmpdat), sizeof ( dbs_Game ) );
   end_insert ( tmptag );

   return ( tmptag );
}

void Game::DBupdate ( void )
{
   if ( p_readonly == false )
   {
      dbs_Game tmpdat;

   strncpy ( tmpdat.adventurefile, p_adventurefile, 12 );
   strncpy ( tmpdat.savegamefile, p_savegamefile, 12 );
   strncpy ( tmpdat.password, p_password, 10 );
   if ( p_pass_protect == true )
      tmpdat.pass_protect = 1;
   else
      tmpdat.pass_protect = 0;
   tmpdat.difficulty = p_difficulty;
   tmpdat.levelup = p_levelup;

      db.update ( p_reftag,
         static_cast<void*>(&tmpdat), sizeof ( dbs_Game ) );
      end_update();
   }

}

void Game::DBselect ( DBTag value, bool readonly )
{
   dbs_Game tmpdat;
   if ( db.select ( &tmpdat, value, sizeof ( dbs_Game ) ) == true )
   {

      p_adventurefile = tmpdat.adventurefile;
      p_savegamefile = tmpdat.savegamefile;
      p_password = tmpdat.password;
      if ( tmpdat.pass_protect == 1 )
         p_pass_protect = true;
      else
         p_pass_protect = false;
      p_difficulty = tmpdat.difficulty;
      p_levelup = tmpdat.levelup;
   
      end_select ( value, readonly );
   }
}

void Game::DBselect ( dword index, bool readonly )
{
   dbs_Game tmpdat;
   if ( db.select ( &tmpdat, index, sizeof ( dbs_Game ) ) == true )
   {
      p_adventurefile = tmpdat.adventurefile;
      p_savegamefile = tmpdat.savegamefile;
      p_password = tmpdat.password;
      if ( tmpdat.pass_protect == 1 )
         p_pass_protect = true;
      else
         p_pass_protect = false;
      p_difficulty = tmpdat.difficulty;
      p_levelup = tmpdat.levelup;
   
      end_select ( db.get_tag ( index ), readonly );
   }
}

void Game::DBremove ( void )
{
   // todo remove all player in games
   delete_file ( p_savegamefile.data() );

   db.remove ( p_reftag );
   end_remove();
}                                           */

void Game::objdat_to_strdat ( void *dataptr )
{
   dbs_Game &tmpdat = *(static_cast<dbs_Game*> ( dataptr ));

//   strncpy ( tmpdat.adventurefile, p_adventurefile, 12 );
   strncpy ( tmpdat.savegamefile, p_savegamefile, 23 );
   strncpy ( tmpdat.password, p_password, 11 );
   if ( p_pass_protect == true )
      tmpdat.pass_protect = 1;
   else
      tmpdat.pass_protect = 0;
   tmpdat.difficulty = p_difficulty;
   tmpdat.levelup = p_levelup;

   tmpdat.adventure = p_adventure.number();
   
}

void Game::strdat_to_objdat ( void *dataptr )
{
   dbs_Game &tmpdat = *(static_cast<dbs_Game*> ( dataptr ));

//      p_adventurefile = tmpdat.adventurefile;
      strcpy ( p_savegamefile, tmpdat.savegamefile );
      strcpy ( p_password, tmpdat.password );
      if ( tmpdat.pass_protect == 1 )
         p_pass_protect = true;
      else
         p_pass_protect = false;
      p_difficulty = tmpdat.difficulty;
      p_levelup = tmpdat.levelup;

      p_adventure.number( tmpdat.adventure );

      
}

void Game::child_DBremove ( void )
{
   // todo remove all player in games ( not sure )
   delete_file ( p_savegamefile );

}





