/***************************************************************************/
/*                                                                         */
/*                          E N N E M Y . C P P                            */
/*                            Class Source Code                            */
/*                                                                         */
/*     Content : Class Ennemy                                              */
/*     Programmer : Eric Pietrocupo                                        */
/*     Starting Date : Mai 18th, 2002                                      */
/*     License : GNU General Public License                                */
/*                                                                         */
/***************************************************************************/

#include <allegro.h>
#include <general.h>

#include <stdio.h>   // to comment
//#include <stdlib.h>
//#include <time.h>

//#include <dbdata.h>
//#include <dbtag.h>
//#include <database.h>
//#include <dbobject.h>
#include <ddt.h>
#include <dbdef.h>
#include <string.h>
//#include <datafile.h>
//#include <datmacro.h>
#include <system.h>
//#include <init.h>
//#include <menu.h>
//#include <option.h>
//#include <screen.h>
#include <item.h>
//#include <armor.h>
#include <weapon.h>
//#include <shield.h>
//#include <accesory.h>
//#include <expandbl.h>
//#include <list.h>
#include <opponent.h>
//#include <charactr.h>
#include <ennemy.h>
//#include <party.h>
//#include <player.h>
//#include <game.h>
//#include <city.h>
//#include <maze.h>
//#include <adventur.h>
//#include <camp.h>
//#include <config.h>
//#include <draw.h>
//#include <dialog.h>
//#include <combat.h>
//#include <window.h>
//#include <winmessa.h>


/*-------------------------------------------------------------------------*/
/*-                     Constructor and Destructor                        -*/
/*-------------------------------------------------------------------------*/
Ennemy::Ennemy ( void )
{
   tiny i;
   
   p_dblength = sizeof ( dbs_Ennemy );
   p_dbtableID = DBTABLE_ENNEMY;
   p_type = Opponent_TYPE_ENNEMY;
}


Ennemy::~Ennemy ( void )
{

}

/*-------------------------------------------------------------------------*/
/*-                       Property Methods                                -*/
/*-------------------------------------------------------------------------*/


const char* Ennemy::group_name ( void )
{
   return ( p_group_name );
}

tiny Ennemy::eprob ( void )
{
   return ( p_eprob );
}

tiny Ennemy::rankpriority ( void )
{
   return ( p_rankpriority );
}


/*-------------------------------------------------------------------------*/
/*-                            Virtual Methods                            -*/
/*-------------------------------------------------------------------------*/

void Ennemy::eval_stat_other ( void )
{
   tiny DMGdice [ 5 ]= { 4, 6, 8, 10, 12 };
   tiny levelmod;

   // direct copy
   p_stat.elm_resist = p_elm_resist;
   p_stat.hlt_resist = p_hlt_resist;
   p_stat.elm_effect = p_elm_effect;
   p_stat.hlt_effect = p_hlt_effect;
   p_stat.magikproperty = p_magikproperty;
   p_stat.dmg_type = p_dmg_type;
   p_stat.range = p_range;
   p_stat.nb_max_attack = p_nb_max_attack;
   
   // compiled bonus
   p_stat.hitbonus += p_hitbonus;
   p_stat.encmod += p_encmod;
   p_stat.dmg_x += p_dmg_x;
   p_stat.dmg_z += p_dmg_z;
//   p_stat.mdmg_x += p_mdmg_x;
   p_stat.mdmg_z += p_mdmg_z;
   p_stat.PD += p_PD;
   p_stat.AD += p_AD;
   p_stat.DR += p_DR;
   p_stat.MDR += p_MDR;
   p_stat.MPD += p_MPD;
   p_stat.MAD += p_MAD;
   p_stat.PSAVE += p_PSAVE;
   p_stat.MSAVE += p_MSAVE;
   p_stat.init += p_init;


   levelmod = p_level / 6;
   p_stat.dmg_y += levelmod;
   p_stat.mdmg_y += levelmod;

   // generated info

   if ( p_static_dmg == 0 )
   {
      p_stat.dmg_y += DMGdice [ p_size ];
//      p_stat.dmg_z += STRmodifier();
   }
   else
      p_stat.dmg_y += p_static_dmg;
      
   p_stat.mdmg_y += 8;

   p_stat.multihitmod = 16 - ( p_level / 3 );

/*   switch ( p_hitattrib )
   {
      case Weapon_ATTRIB_STR :
         p_stat.hitbonus += STRmodifier();//strength();
      break;
      case Weapon_ATTRIB_INT :
         p_stat.hitbonus += INTmodifier();//intelligence();
      break;
      case Weapon_ATTRIB_DEX :
         p_stat.hitbonus += DEXmodifier();//dexterity();
      break;
   }*/


}



void Ennemy::name_combat ( char *str )
{
   strcpy ( str, p_name );
}

/*void Ennemy::save_vs ( Word healthID, tiny modifier )
{
   tiny value;
   tiny attribute;

   if ( healthID > Opponent_PHYSICAL_HEALTH_LIMIT )
      attribute = p_attribute [ Opponent_WILLPOWER ];
   else
      attribute = p_attribute [ Opponent_ENDURANCE ];

   value = rnd(20);

   if ( ( ( attribute + modifier ) < value || value == 20 ) && value != 1 )
      add_health ( healthID );
} */

void Ennemy::objdat_to_strdat ( void *dataptr )
{
   dbs_Ennemy &tmpdat = *(static_cast<dbs_Ennemy*> ( dataptr ));

   tiny i;
//   tiny j;
   Opponent::objdat_to_strdat ( dataptr );

   strncpy ( tmpdat.group_name, p_group_name, 16 );
   tmpdat.elm_resist = p_elm_resist;
   tmpdat.hlt_resist = p_hlt_resist;
   tmpdat.elm_effect = p_elm_effect;
   tmpdat.hlt_effect = p_hlt_effect;
   tmpdat.magikproperty = p_magikproperty;
   tmpdat.hitbonus = p_hitbonus;
   tmpdat.encmod = p_encmod;
   tmpdat.dmg_x = p_dmg_x;
   tmpdat.dmg_z = p_dmg_z;
   tmpdat.dmg_type = p_dmg_type;
   tmpdat.mdmg_z = p_mdmg_z;
   tmpdat.range = p_range;
   tmpdat.static_dmg = p_static_dmg;
   tmpdat.hitattrib = p_hitattrib;
   tmpdat.nb_max_attack = p_nb_max_attack;
   tmpdat.PD = p_PD;
   tmpdat.AD = p_AD;
   tmpdat.DR = p_DR;
   tmpdat.MDR = p_MDR;
   tmpdat.MPD = p_MPD;
   tmpdat.MAD = p_MAD;
   tmpdat.PSAVE = p_PSAVE;
   tmpdat.MSAVE = p_MSAVE;
   tmpdat.init = p_init;

   tmpdat.eprob = p_eprob;
   tmpdat.rankpriority = p_rankpriority;

   for ( i = 0 ; i < Ennemy_NB_SPELL ; i++ )
      tmpdat.spell [ i ] = p_spell [ i ];

   for ( i = 0 ; i < Ennemy_NB_ACTION ; i++ )
      tmpdat.action [ i ] = p_action [ i ];


}
void Ennemy::strdat_to_objdat ( void *dataptr )
{
   dbs_Ennemy &tmpdat = *(static_cast<dbs_Ennemy*> ( dataptr ));

   tiny i;
//   tiny j;
   Opponent::strdat_to_objdat ( dataptr );

   strcpy ( p_group_name, tmpdat.group_name );

   p_elm_resist = tmpdat.elm_resist;
   p_hlt_resist = tmpdat.hlt_resist;
   p_elm_effect = tmpdat.elm_effect;
   p_hlt_effect = tmpdat.hlt_effect;
   p_magikproperty = tmpdat.magikproperty;
   p_hitbonus = tmpdat.hitbonus;
   p_encmod = tmpdat.encmod;
   p_dmg_x = tmpdat.dmg_x;
   p_dmg_z = tmpdat.dmg_z;
   p_dmg_type = tmpdat.dmg_type;
   p_mdmg_z = tmpdat.mdmg_z;
   p_range = tmpdat.range;
   p_static_dmg = tmpdat.static_dmg;
   p_hitattrib = tmpdat.hitattrib;
   p_nb_max_attack = tmpdat.nb_max_attack;
   p_PD = tmpdat.PD;
   p_AD = tmpdat.AD;
   p_DR = tmpdat.DR;
   p_MDR = tmpdat.MDR;
   p_MPD = tmpdat.MPD;
   p_MAD = tmpdat.MAD;
   p_PSAVE = tmpdat.PSAVE;
   p_MSAVE = tmpdat.MSAVE;
   p_init = tmpdat.init;

   p_eprob = tmpdat.eprob;
   p_rankpriority = tmpdat.rankpriority;
      
   for ( i = 0 ; i < Ennemy_NB_SPELL ; i++ )
      p_spell [ i ] = tmpdat.spell [ i ];

   for ( i = 0 ; i < Ennemy_NB_ACTION ; i++ )
      p_action [ i ] = tmpdat.action [ i ];


}
/*
void Ennemy::child_DBremove ( void )
{
   // no work do do here
} */

void Ennemy::alternate_strdat_to_objdat ( tiny datatypeID, void *dataptr )
{
   switch ( datatypeID )
   {
      case Ennemy_DATATYPE_MONSTER :
         monster_strdat_to_objdat ( dataptr );
      break;
   }
}

void Ennemy::monster_strdat_to_objdat ( void *dataptr )
{
   tiny i;
   tiny attribavg;
   tiny roll;
   short mask;
   dbs_Ennemy_monster &tmpdat = *(static_cast<dbs_Ennemy_monster*> ( dataptr ));
   char tmpstr [ 16 ];
   tiny HPdice [ 5 ] = { 4, 6, 8, 10, 12 };
   

   // generated information
   p_type = Opponent_TYPE_ENNEMY;
   p_status = Opponent_STATUS_ALIVE;
   p_soul = 100;
   p_health = 0;
   
   for ( i = 0; i < 6 ; i++ )
      p_attribute [ i ] = 10;
   p_attribute [ Opponent_LUCK ] = 0;

   p_max_HP = HPdice [ tmpdat.size ];
   p_max_MP = 8;
   for ( i = 0 ; i < tmpdat.level ; i++ )
   {
      p_max_HP += hdice ( HPdice [ tmpdat.size ] ) - ( i / 5 );
      p_max_MP += hdice ( 8 ) - ( i / 5 );
   }
   
   p_current_HP = p_max_HP;
   p_current_MP = p_max_MP;

   // monster struct source copy
   strcpy ( p_name, tmpdat.name );
   strcpy ( p_group_name, tmpdat.group_name );
   p_size = tmpdat.size;
   p_aligment = tmpdat.aligment;
   p_level = tmpdat.level;
   p_elm_weakness = tmpdat.elm_weakness;
   p_reward_exp = tmpdat.reward_exp;
   p_gold = tmpdat.gold;
   p_pictureID = tmpdat.pictureID;
   p_elm_resist = tmpdat.elm_resist;
   p_hlt_resist = tmpdat.hlt_resist;
   p_elm_effect = tmpdat.elm_effect;
   p_hlt_effect = tmpdat.hlt_effect;
   p_magikproperty = tmpdat.magikproperty;
   p_hitbonus = tmpdat.hitbonus;
   p_encmod = tmpdat.encmod;
   p_dmg_x = tmpdat.dmg_x;
   p_dmg_z = tmpdat.dmg_z;
   p_dmg_type = tmpdat.dmg_type;
   p_mdmg_z = tmpdat.mdmg_z;
   p_range = tmpdat.range;
   p_static_dmg = tmpdat.static_dmg;
   p_hitattrib = tmpdat.hitattrib;
   p_nb_max_attack = tmpdat.nb_max_attack;
   p_PD = tmpdat.PD;
   p_AD = tmpdat.AD;
   p_DR = tmpdat.DR;
   p_MDR = tmpdat.MDR;
   p_MPD = tmpdat.MPD;
   p_MAD = tmpdat.MAD;
   p_PSAVE = tmpdat.PSAVE;
   p_MSAVE = tmpdat.MSAVE;
   p_init = tmpdat.init;
   p_eprob = tmpdat.eprob;
   p_rankpriority = tmpdat.rankpriority;
   

//   for ( i = 0 ; i < 6 ; i++ )
//      p_attribute [ i ] = tmpdat.attribute [ i ];

   for ( i = 0 ; i < Ennemy_NB_ACTION ; i++ )
      p_action [ i ] = tmpdat.action [ i ];

   for ( i = 0 ; i < Ennemy_NB_SPELL ; i++ )
      p_spell [ i ] = tmpdat.spell [ i ];

   // view opponent info
/*      textprintf ( buffer, font, 0, 0, General_COLOR_TEXT,
         "%s | %s | lv %d | size %d |", tmpdat.name, tmpdat.group_name,
         tmpdat.level, tmpdat.size );
      copy_buffer();
      while ( ( readkey() >> 8 ) != KEY_ENTER );*/

}

// opponent
/*   char name [ 16 ] a_packed;
   tiny type a_packed;
   tiny size a_packed;
   short max_HP a_packed;
   short current_HP a_packed;
   short max_MP a_packed;
   short current_MP a_packed;
   tiny aligment a_packed;
   tiny attribute [ 7 ] a_packed;
   tiny level a_packed;
   tiny soul a_packed;
   word health a_packed;
   tiny status a_packed;
   word elm_weakness a_packed;
   short reward_exp a_packed;
   short gold a_packed;
   byte pictureID a_packed;*/

   // opponent stat
/*   word elm_resist a_packed;
   word hlt_resist a_packed;
   word elm_effect a_packed;
   word hlt_effect a_packed;
   word magikproperty a_packed;
   tiny multihitmod a_packed;
   tiny hitbonus a_packed;
   tiny encmod a_packed;
   tiny dmg_x a_packed;
   tiny dmg_y a_packed;
   tiny dmg_z a_packed;
   tiny dmg_type a_packed;
   tiny mdmg_x a_packed;
   tiny mdmg_y a_packed;   
   tiny mdmg_z a_packed;
   tiny range a_packed;
   tiny hitroll a_packed;
   tiny nb_max_attack a_packed;
   tiny PD a_packed;
   tiny AD a_packed;
   tiny DR a_packed;
   tiny MDR a_packed;   
   tiny MPD a_packed;
   tiny MAD a_packed;
   tiny PSAVE a_packed;
   tiny MSAVE a_packed;
   tiny init a_packed;
*/


// monster
/*   char name [ 16 ] a_packed;
   char group_name [ 16 ] a_packed;   
   tiny level a_packed;
   tiny size a_packed;
   tiny aligment a_packed;
   short reward_exp a_packed;
   short gold a_packed;
   byte pictureID a_packed;
   tiny attribute [ 6 ] a_packed;
   word elm_weakness a_packed;
   word elm_resist a_packed;
   word hlt_resist a_packed;
   word elm_effect a_packed;
   word hlt_effect a_packed;
   word magikproperty a_packed;
   tiny hitbonus a_packed;
   tiny encumbrance a_packed;
   tiny dmg_x a_packed;
   tiny dmg_z a_packed;
   tiny dmg_type a_packed;
   tiny mdmg_x a_packed;
   tiny mdmg_z a_packed;
   tiny range a_packed;
   tiny static_dmg a_packed;
   tiny hitattrib a_packed;
   tiny nb_max_attack a_packed;
   tiny PD a_packed;
   tiny AD a_packed;
   tiny DR a_packed;
   tiny MDR a_packed;   
   tiny MPD a_packed;
   tiny MAD a_packed;
   tiny PSAVE a_packed;
   tiny MSAVE a_packed;
   tiny init a_packed;
   tiny action [ Ennemy_NB_ACTION ] a_packed;
   tiny spell [ Ennemy_NB_SPELL ] a_packed;
*/
   

// ennemy
/*   char group_name [ 16 ] a_packed;
   byte action [ Ennemy_NB_ACTION ] a_packed;
   byte spell [ Ennemy_NB_SPELL ] a_packed;
   word elm_resist a_packed;
   word hlt_resist a_packed;
   word elm_effect a_packed;
   word hlt_effect a_packed;
   word magikproperty a_packed;
   tiny hitbonus a_packed;
   tiny encumbrance a_packed;
   tiny dmg_x a_packed;
   tiny dmg_z a_packed;
   tiny dmg_type a_packed;
   tiny mdmg_x a_packed;
   tiny mdmg_z a_packed;
   tiny range a_packed;
   tiny static_dmg a_packed;
   tiny hitattrib a_packed;
   tiny nb_max_attack a_packed;
   tiny PD a_packed;
   tiny AD a_packed;
   tiny DR a_packed;
   tiny MDR a_packed;   
   tiny MPD a_packed;
   tiny MAD a_packed;
   tiny PSAVE a_packed;
   tiny MSAVE a_packed;
   tiny init a_packed;
*/
