/***************************************************************************/
/*                                                                         */
/*                        E N C O U N T R . C P P                          */
/*                          Class Source Code                              */
/*                                                                         */
/*     Content : Class Encounter                                           */
/*     Programmer : Eric Pietroucpo                                        */
/*     Starting Date : November 1st, 2003                                  */
/*     License : GNU General Public LIcense                                */
/*                                                                         */
/***************************************************************************/

#include <allegro.h>
#include <general.h>
#include <stdio.h>
//#include <stdlib.h>
//#include <time.h>
#include <string.h>
#include <datafile.h>
#include <advdatf.h>
#include <datmacro.h>
#include <system.h>
//#include <init.h>
#include <menu.h>
#include <option.h>
//#include <screen.h>
//#include <dbdata.h>
//#include <dbtag.h>
//#include <database.h>
//#include <dbobject.h>
#include <ddt.h>
#include <dbdef.h>
#include <item.h>
//#include <armor.h>
//#include <weapon.h>
//#include <shield.h>
//#include <accesory.h>
//#include <expandbl.h>
//#include <list.h>
#include <race.h>
#include <cclass.h>
#include <opponent.h>
#include <charactr.h>
#include <ennemy.h>
#include <account.h>
#include <party.h>
#include <player.h>
#include <game.h>
//#include <account.h>
//#include <city.h>
//#include <maze.h>
#include <encountr.h>
//#include <adventur.h>
//#include <camp.h>
#include <config.h>
//#include <draw.h>
//#include <dialog.h>
//#include <combat.h>
#include <window.h>
#include <winmenu.h>
#include <winempty.h>
#include <wintitle.h>
#include <windata.h>
#include <wdatproc.h>
#include <winmessa.h>
#include <winquest.h>


/*-------------------------------------------------------------------------*/
/*-                        Constructor and Destructor                     -*/
/*-------------------------------------------------------------------------*/

Encounter::Encounter ( void )
{
   clear_list();
   clear_selection();
}

Encounter::~Encounter ( void )
{

}


/*-------------------------------------------------------------------------*/
/*-                            Property Methods                           -*/
/*-------------------------------------------------------------------------*/

short Encounter::nb_ennemy ( void )
{
   return ( p_nb_ennemy );
}

void Encounter::probability ( tiny value )
{
   p_probability = value;
}

tiny Encounter::probability ( void )
{
   return ( p_probability );
}

tiny Encounter::counter ( void )
{
   return ( p_counter );
}


/*-------------------------------------------------------------------------*/
/*-                               Methods                                 -*/
/*-------------------------------------------------------------------------*/

void Encounter::build_list ( tiny base, tiny range, word mask )
{
   Ennemy tmpennemy;
   dword index = db.search_table_entry ( DBTABLE_MONSTER );
   short i = 0;
   bool accept_ennemy;
   tiny min_level = base;
   tiny max_level = base + range - 1;

   clear_selection();

   p_nb_ennemy = 0;
   short y = 0;
   char tmpstr [ 16 ];

//   textprintf ( buffer, font, 0, 0, General_COLOR_TEXT,
//      "Sizeof : %d", sizeof ( dbs_Ennemy_monster ) );
//   copy_buffer ();
//   while ( ( readkey() >> 8 ) != KEY_ENTER );
   
   do
   {
/*      db.select ( tmpstr, index, 16 );
   textprintf ( buffer, font, 0, 0, General_COLOR_TEXT,
      "index : %d : string : %s", index, tmpstr );

   copy_buffer ();
   while ( ( readkey() >> 8 ) != KEY_ENTER );*/
   
      tmpennemy.alDBselect ( Ennemy_DATATYPE_MONSTER,
         sizeof ( dbs_Ennemy_monster ), index );
      accept_ennemy = false;



/*      textprintf ( buffer, font, 0, y, General_COLOR_TEXT,
         "%s | %s | lv %d", tmpennemy.cname(), tmpennemy.cgroup_name(),
         tmpennemy.level() );
      y = y + 16;
      copy_buffer();
      while ( ( readkey() >> 8 ) != KEY_ENTER );*/

      if ( ( tmpennemy.level() >= min_level )
         && ( tmpennemy.level() <= max_level ) )
         accept_ennemy = true;

      if ( accept_ennemy == true )
      {
/*         WinData<Opponent> wdat_opponnent_stat ( WDatProc_opponent_stat,
            tmpennemy, WDatProc_POSITION_OPPONENT_STAT );
         Window::show_all();
         copy_buffer();
         while ( ( readkey() >> 8 ) != KEY_ENTER );*/
            
         p_elist [ i ] = tmpennemy.tag();
         i++;
         p_nb_ennemy++;
      }
      index++;
   }
   while ( db.entry_table_tag ( index ) == DBTABLE_MONSTER );

}

void Encounter::clear_list ( void )
{
   short i;

   for ( i = 0 ; i < Encounter_ELIST_SIZE ; i++ )
      p_elist [ i ] = 0;
      
   p_nb_ennemy = 0;
   p_probability = 0;

}

bool Encounter::check_encounter ( byte solid, bool door )
{
   tiny side = 0;
   tiny dir = 3;
  // bool enc_side [ 4 ] = { false, false, false, false };
   tiny rndval = 0;
   bool encounter_found = false;
   char tmpstr [100];
//   short tmprob;
//   string cmpstr;

//?? remove facing but keep increase of probabilities for multiple oppening

//   if ( door == true )
//      tmprob = p_probability * 2;
//   else
//      tmprob = p_probability;

   p_door = door;

   if ( p_nb_ennemy > 0 )
   {
      for ( side = 0 ; side < 4 ; side++ )
      {
         if ( ( solid & dir ) == 0 )
         {
            p_counter -= p_probability;
//            rndval = rnd( p_decrement );
//            sprintf ( tmpstr, " | dir %d open (%d/%d)", dir, rndval, tmprob );

//            if ( rndval <= tmprob )
//            {
//               enc_side [ side ] = true;
//               encounter_found = true;
//            }
         }
//         else
//            sprintf ( tmpstr, "| dir %d close", dir, rndval, tmprob );

         dir = dir<<2;
//         if ( dir > 8 )
//            dir = 1;

//      cmpstr += tmpstr;
//      if ( side == 1 )
//         cmpstr += "\n";
      }
//   WinMessage wmsg_random ( cmpstr );

//   Window::show_all();

     if ( door == true )
     {
        rndval = rnd( 100 );
        if ( rndval >= p_counter )
           encounter_found = true;
     }
     else
     {
        if ( p_counter <= 0 )
           encounter_found = true;
     }

      if ( encounter_found == true )
      {
         select_encounter ();

      // setting value like this determine priority ( from front to back )
/*         if ( enc_side [ Encounter_SIDE_BACK ] == true )
            p_side = Encounter_SIDE_BACK;

         if ( enc_side [ Encounter_SIDE_LEFT ] == true )
            p_side = Encounter_SIDE_LEFT;

         if ( enc_side [ Encounter_SIDE_RIGHT ] == true )
            p_side = Encounter_SIDE_RIGHT;

         if ( enc_side [ Encounter_SIDE_LEFT ] == true
            && enc_side [ Encounter_SIDE_RIGHT ] == true )
         {
            // allow even probabilities for left and right
            rndval = rnd(2);
            if ( rndval == 1 )
               p_side = Encounter_SIDE_LEFT;
            else
               p_side = Encounter_SIDE_RIGHT;
         }

         if ( enc_side [ Encounter_SIDE_FRONT ] == true )
            p_side = Encounter_SIDE_FRONT;*/

      }
   }

//   p_decrement -= p_probability;

//   if ( p_decrement < 4 )
//      p_decrement = 4;

   return ( encounter_found );
}

tiny Encounter::start ( DBTag party )
{
   Ennemy tmpenn;
   Party tmparty;
   DBTag tmptag;
//   string tmpstr;
   char strmsg [ 241 ];
   tiny i;
   tiny j;
   bool engage = false;
   bool nodouble = true;
   bool friendly = false;
   bool docombat = false;
   tiny answer;
   tiny rndval;

//   play_music_track ( System_MUSIC_w3fight );
   stop_midi();
   play_sample ( SMP_sound038, 128, 128, 1000, 0 );
   WinTitle wttl_encounter ("Encounter", 320, 200 );

   load_backup_screen();
   Window::draw_all();
   copy_buffer();

   rest ( 800 );

   wttl_encounter.hide();
   rndval = rnd ( 5 );
   //?? maybe change probability with scouting ability

   if ( rndval == 5 && p_door != true )
   {
      strcpy ( strmsg, "You see ahead a group of\n" );

      for ( i = 0 ; i < p_nb_selected ; i++ )
      {
         nodouble = true;
         for ( j = 0 ; j < i ; j++ )
         {
            if ( p_selection [ i ] == p_selection [ j ] )
               nodouble = false;
         }
         if ( nodouble == true )
         {
            tmpenn.alDBselect ( Ennemy_DATATYPE_MONSTER,
               sizeof ( dbs_Ennemy_monster ), p_selection [ i ] );
            strcat ( strmsg, tmpenn.group_name() );
            strcat ( strmsg, ", " );
         }
      }
      strcat ( strmsg, "\nDo you want to engage ?" );

      WinQuestion wqst_engage ( strmsg, 320, 200 );

      load_backup_screen();
      answer = Window::show_all();

      if ( answer == 0 )
         engage = true;
   }
   else
      engage = true;

   if ( engage == true )
   {

      //?? check for friendlyness
      //?? Check for surprise

      if ( friendly == true )
      {
         strcpy ( strmsg, "Encounter is friendly" );
         WinMessage wmsg_friendly ( strmsg, 320, 200 );
         wmsg_friendly.preshow();
         
         load_backup_screen();
         Window::draw_all();
         copy_buffer();
         
         rest ( 1000 );
         return ( Encounter_END );
      }
      else
      {
         strcpy ( strmsg, "You engage the Ennemy" );
         db.default_source ( DBSOURCE_TEMP );

         for ( i = 0 ; i < p_nb_selected ; i++ )
         {
            tmpenn.alDBselect ( Ennemy_DATATYPE_MONSTER,
               sizeof ( dbs_Ennemy_monster ), p_selection [ i ] );
/*         WinData<Opponent> wdat_opponnent_stat ( WDatProc_opponent_stat,
            tmpenn, WDatProc_POSITION_OPPONENT_STAT );
         Window::show_all();
         copy_buffer();
         while ( ( readkey() >> 8 ) != KEY_ENTER );*/
               
            tmptag = tmpenn.DBinsert();
            tmparty.add_character ( tmptag );
         }

         tmparty.ennemy_rankprioritysort();
         p_party = tmparty.DBinsert();
         docombat = true;
         db.default_source ( DBSOURCE_SAVEGAME );

         WinMessage wmsg_engage ( strmsg, 320, 200 );
         wmsg_engage.preshow();
         
         load_backup_screen();
         Window::draw_all();
         copy_buffer();
         rest ( 1000 );
         return ( Encounter_ENGAGE );
      }
   }

   return ( Encounter_IGNORE );
}

void Encounter::clear_selection ( void )
{
   tiny i;
   
   for ( i = 0 ; i < 6 ; i++ )
      p_selection [ 6 ].number (0);
//   p_side = 0;
   p_nb_selected = 0;
   p_counter = 100;
   p_party.number(0);
   p_door = false;

}

void Encounter::clear_objects ( void )
{
   Party tmparty;
   Ennemy tmpenn;
   tiny i;

   tmparty.DBselect ( p_party );

   for ( i = 0 ; i < tmparty.nb_character() ; i++ )
   {
      tmpenn.DBselect ( tmparty.character ( i ) );
      tmpenn.DBremove();
   }

   tmparty.DBremove();
   
}

DBTag Encounter::get_ennemy_party ( void )
{
   return ( p_party );
}


/*-------------------------------------------------------------------------*/
/*-                            Private Methods                            -*/
/*-------------------------------------------------------------------------*/

void Encounter::select_encounter ( void )
{
   short rndval;
   tiny ngprob = 100;
   bool endselect = false;
   tiny grpsize;
   tiny maxgrpsize;
   short ennid;
   tiny i;
   tiny index;
   bool selectOK;
   Ennemy tmpennemy;


   clear_selection();

   index = 0;
   while ( endselect == false )
   {
      rndval = rnd(100);
      if ( rndval <= ngprob && p_nb_selected < 6 )
      {
         maxgrpsize = 6 - p_nb_selected;
         if ( maxgrpsize > 3 )
            maxgrpsize = 3;
         
         grpsize = rnd(maxgrpsize);

         selectOK = false;
         while ( selectOK == false )
         {
            ennid = rnd ( p_nb_ennemy );
            tmpennemy.alDBselect ( Ennemy_DATATYPE_MONSTER,
               sizeof ( dbs_Ennemy_monster ), p_elist [ ennid - 1 ] );
            if ( rnd ( 100 ) <= tmpennemy.eprob() )
               selectOK = true;
         }
         
         for ( i = 0 ; i < grpsize; i++ )
         {
            p_selection [ index ] = p_elist [ ennid - 1 ];
            index++;
         }

         ngprob = ngprob / 2;
         p_nb_selected = p_nb_selected + grpsize;
      }
      else
         endselect = true;
   }

//   maxgrpsize = 2;//rnd ( 3 );
   
//   tmpval = 6 / maxgrpsize;

//   if ( tmpval == 1 )
//      nbgrp = 1;
//   else
//      nbgrp = 2;//rnd ( tmpval );

//   index = 0;
/*   for ( j = 0 ; j < 1 ; j++ )
   {
//      if ( maxgrpsize == 1 )
//         grpsize = 1;
//      else
         grpsize = 2;//rnd ( maxgrpsize );
         
      ennid = rnd ( p_nb_ennemy );
      for ( i = 0 ; i < 2; i++ )
      {
         p_selection [ index ] = p_elist [ ennid ];
         index++;
      }
   }*/

//      p_selection [ 0 ] = p_elist [ rnd ( p_nb_ennemy ) ];
//      p_selection [ 1 ] = p_elist [ rnd ( p_nb_ennemy ) ];
//      p_nb_selected = 2;
//      for ( i = 0 ; i < 2; i++ )
//      {
//         p_selection [ index ] = p_elist [ ennid ];
//         index++;
//      }

   
   //?? todo : reorder monster according to location priority

}



