/***************************************************************************/
/*                                                                         */
/*                         E D I T O R . C P P                             */
/*                         Class Source Code                               */
/*                                                                         */
/*     Content : Class Editor source code                                  */
/*     Programmer : Eric Pietrocupo                                        */
/*     Starting Date : February 22nd, 2004                                 */
/*     License : GNU General Public License                                */
/*                                                                         */
/***************************************************************************/

#include <general.h>
#include <stdio.h>
#include <stdlib.h>
//#include <time.h>
#include <allegro.h>
//#include <string.h>
#include <datafile.h>
#include <advdatf.h>
#include <datmacro.h>
#include <system.h>
//#include <init.h>
//#include <menu.h>
//#include <option.h>
//#include <screen.h>
//#include <dbdata.h>
//#include <dbtag.h>
//#include <database.h>
//#include <dbobject.h>
#include <ddt.h>
#include <dbdef.h>
#include <item.h>
//#include <armor.h>
//#include <weapon.h>
//#include <shield.h>
//#include <accesory.h>
//#include <expandbl.h>
//#include <list.h>
#include <race.h>
#include <opponent.h>
#include <charactr.h>
//#include <monster.h>
#include <party.h>
#include <player.h>
#include <game.h>
#include <account.h>
//#include <city.h>
#include <maze.h>
#include <editor.h>
#include <encountr.h>
#include <mazeproc.h>
//#include <adventur.h>
//#include <camp.h>
#include <config.h>
#include <draw.h>
//#include <dialog.h>
//#include <combat.h>
#include <window.h>
#include <winquest.h>
#include <winmessa.h>
#include <wintitle.h>
#include <windata.h>
#include <wdatproc.h>


/*-------------------------------------------------------------------------*/
/*-                      Constructor & Destructor                         -*/
/*-------------------------------------------------------------------------*/

Editor::Editor ( void )
{
   short i;
   short j;
   short k;
   s_Maze_tile tile;

   p_width = 40;
   p_depth = 10;
   p_sky = -1;
   p_rclevel = 0;
   p_startpos.x = 0;
   p_startpos.y = 0;
   p_startpos.z = 0;
   p_startpos.facing = Party_FACE_NORTH;

   p_xcur = 5;
   p_ycur = 5;
   p_zcur = 0;

   p_xscroll = 0;
   p_yscroll = 0;
   

   tile.walltex = 0;
   tile.floortex = 0;
   tile.objectimg = 0;
   tile.event = 0;
   tile.special = 0;
   tile.texture = 0;
   tile.solid = 0;

/*

   k = 0;
   j = 0;
   for ( k = 0 ; k < Maze_MAXDEPTH; k++ )
       for ( j = 0 ; j < Maze_MAXWIDTH; j++ )
       {
         for ( i = 0 ; i < Maze_MAXWIDTH; i++ )
         {
            p_map [ i ] [ j ] [ k ] = tile;
         }
       }*/

//   p_map = create_bitmap ( 640, 480 );


}

Editor::~Editor ( void )
{

}


/*-------------------------------------------------------------------------*/
/*-                            Methods                                    -*/
/*-------------------------------------------------------------------------*/

void Editor::start ( void )
{
   clear ( buffer );
   clear ( backup );
   p_xcur = 5;
   p_ycur = 5;
   p_zcur = 0;
   p_xscroll = 0;
   p_yscroll = 0;
   byte tmpbyte;
   byte tmpbyte2;

   byte tmpkey = 0;
   
//   textout_centre ( backup, font, "This is a test", 320, 200,
//      General_COLOR_TEXT );

   while ( tmpkey != KEY_ESC )
   {
      read_curtile();
      draw_map ();
      draw_detailed_tile();

      copy_background();
      copy_buffer();

      tmpkey = ( readkey() >> 8);
      clear_keybuf();

      switch ( tmpkey )
      {
         case KEY_RIGHT :
            if ( p_xcur < p_width - 1 )
            {
               p_xcur++;
               if ( p_xscroll < ( p_xcur - 25 ) &&
                  p_xscroll < 100 - 25 )
                  p_xscroll++;
            }
         break;

         case KEY_LEFT :
            if ( p_xcur > 0 )
            {
               p_xcur--;
               if ( p_xscroll > ( p_xcur )  &&
                  p_xscroll > 0  )
                  p_xscroll--;
            }
         break;

         case KEY_UP :
            if ( p_ycur < p_width - 1 )
            {
               p_ycur++;
               if ( p_yscroll < ( p_ycur - 25 ) &&
                  p_yscroll < 100 - 25 )
                  p_yscroll++;
            }
         break;

         case KEY_DOWN :
            if ( p_ycur > 0 )
            {
               p_ycur--;
               if ( p_yscroll > ( p_ycur )  &&
                  p_yscroll > 0  )
                  p_yscroll--;
            }
         break;

         case KEY_PGUP :
            if ( p_zcur > 0 )
               p_zcur--;
         break;

         case KEY_PGDN :
            if ( p_zcur < p_depth -1 )
               p_zcur++;
         break;

         case KEY_7_PAD :  // solid trigger
            if ( p_curtile.special_tech & Maze_SPECIAL_SOLID == 0 )
               p_curtile.special_tech += Maze_SPECIAL_SOLID;
            else
               p_curtile.special_tech -= Maze_SPECIAL_SOLID;
            write_curtile();
/*            tmpbyte = mazetile [p_zcur][p_ycur][p_xcur].special &
               Maze_SPECIAL_SOLID;
            if ( tmpbyte == 0 )
               tmpbyte = Maze_SPECIAL_SOLID;
            else
               tmpbyte = 0;
            mazetile [p_zcur][p_ycur][p_xcur].special = tmpbyte;*/
         break;

/*#define Maze_SPECIAL_TECH_MASK     248 // 11111000b

#define Maze_SPECIAL_DARKNESS        8 // 00001000b
#define Maze_SPECIAL_MAGIKBOUNCE    16 // 00010000b
#define Maze_SPECIAL_SOLID          32 // 00100000b
#define Maze_SPECIAL_LIGHT          64 // 01000000b
*/

         case KEY_8_PAD :
            p_curtile.solid[0]++;
            if ( p_curtile.solid[0] > 3 )
               p_curtile.solid[0] = 0;
            write_curtile();
/*            tmpbyte = (mazetile [p_zcur][p_ycur][p_xcur].solid &
               Maze_SOLID_NORTH_MASK);
            tmpbyte2 = (tmpbyte & ( !Maze_SOLID_NORTH_MASK ));
            tmpbyte = tmpbyte + Maze_SOLID_NORTH_WALL;
            if ( tmpbyte == 256 )
               tmpbyte = 0;
            tmpbyte = tmpbyte + tmpbyte2;
            mazetile [p_zcur][p_ycur][p_xcur].solid = tmpbyte;*/
         break;

         case KEY_6_PAD :
            p_curtile.solid[1]++;
            if ( p_curtile.solid[1] > 3 )
               p_curtile.solid[1] = 0;
            write_curtile();
         
/*            tmpbyte = (mazetile [p_zcur][p_ycur][p_xcur].solid &
               Maze_SOLID_EAST_MASK);
            tmpbyte2 = (tmpbyte & ( !Maze_SOLID_EAST_MASK ));
            tmpbyte = tmpbyte + Maze_SOLID_EAST_WALL;
            if ( tmpbyte == 64 )
               tmpbyte = 0;
            tmpbyte = tmpbyte + tmpbyte2;
            mazetile [p_zcur][p_ycur][p_xcur].solid = tmpbyte;*/
         break;


         case KEY_2_PAD :
            p_curtile.solid[2]++;
            if ( p_curtile.solid[2] > 3 )
               p_curtile.solid[2] = 0;
            write_curtile();
         
/*            tmpbyte = (mazetile [p_zcur][p_ycur][p_xcur].solid &
               Maze_SOLID_SOUTH_MASK);
            tmpbyte2 = (tmpbyte & ( !Maze_SOLID_SOUTH_MASK ));
            tmpbyte = tmpbyte + Maze_SOLID_SOUTH_WALL;
            if ( tmpbyte == 16 )
               tmpbyte = 0;
            tmpbyte = tmpbyte + tmpbyte2;
            mazetile [p_zcur][p_ycur][p_xcur].solid = tmpbyte;*/
         break;


         case KEY_4_PAD :
            p_curtile.solid[3]++;
            if ( p_curtile.solid[3] > 3 )
               p_curtile.solid[3] = 0;
            write_curtile();
         
/*            tmpbyte = (mazetile [p_zcur][p_ycur][p_xcur].solid &
               Maze_SOLID_WEST_MASK);
            tmpbyte2 = (tmpbyte & ( !Maze_SOLID_WEST_MASK ));
            tmpbyte = tmpbyte + Maze_SOLID_WEST_WALL;
            if ( tmpbyte == 4 )
               tmpbyte = 0;
            tmpbyte = tmpbyte + tmpbyte2;
            mazetile [p_zcur][p_ycur][p_xcur].solid = tmpbyte;*/
         break;

         


      }
   }

}

void Editor::load_maz_file ( char *filename )
{
   tiny x;
   tiny y;
   tiny z;
   s_Maze_tile tmptile;
   fs_maz_header mazheader;
   FILE* maz_file;   

   tmptile.walltex = 0;
   tmptile.floortex = 0;
   tmptile.objectimg = 0;
   tmptile.event = 0;
   tmptile.special = 0;
   tmptile.texture = 0;
   tmptile.solid = 0;

   // clean current maze
   for ( z = 0 ; z < Maze_MAXDEPTH; z++ )
       for ( y = 0 ; y < Maze_MAXWIDTH; y++ )
       {
         for ( x = 0 ; x < Maze_MAXWIDTH; x++ )
         {
            mazetile [ z ] [ y ] [ x ] = tmptile;
         }
       }

   if ( exists ( filename ) != 0 )
   {
      maz_file = fopen ( filename, "rb" );

      if ( maz_file != NULL )
      {
         fread ( &mazheader, sizeof ( fs_maz_header ), 1, maz_file );
         
         p_width = mazheader.f_width;
         p_depth = mazheader.f_depth;
         p_sky = mazheader.f_sky;
         p_rclevel = mazheader.f_rclevel;
         p_startpos.x = mazheader.f_startx;
         p_startpos.y = mazheader.f_starty;
         p_startpos.z = mazheader.f_startz;
         p_startpos.facing = mazheader.f_startface;
   //      mazheader.f_reserve;

         for ( z = 0 ; z < p_depth ; z++ )
            for ( y = 0 ; y < p_width ; y++ )
               for ( x = 0 ; x < p_width ; x++ )
               {
                  fread ( &tmptile, sizeof ( s_Maze_tile ), 1, maz_file );
                  mazetile [ z ] [ y ] [ x ] = tmptile;
               }
         fclose ( maz_file );
         textout ( buffer, font, "Passed corectly", 10, 10, General_COLOR_TEXT );
      }
      else
         textout ( buffer, font, "fopen error", 10, 10, General_COLOR_TEXT );
   }
   else
      textout ( buffer, font, "exist error", 10, 10, General_COLOR_TEXT );

   copy_buffer();
   while ( ( readkey()>> 8 ) != KEY_ENTER );
}

void Editor::save_maz_file ( char *filename )
{
   fs_maz_header mazheader;
   s_Maze_tile tmptile;
   FILE* maz_file;
   tiny x;
   tiny y;
   tiny z;

   mazheader.f_width = p_width;
   mazheader.f_depth = p_depth;
   mazheader.f_sky = p_sky;
   mazheader.f_rclevel = p_rclevel;
   mazheader.f_startx = p_startpos.x;
   mazheader.f_starty = p_startpos.y;
   mazheader.f_startz = p_startpos.z;
   mazheader.f_startface = p_startpos.facing;
   mazheader.f_reserved = 0;

   maz_file = fopen ( filename, "wb" );

   if ( maz_file != NULL )
   {

      fwrite ( &mazheader, sizeof ( fs_maz_header ), 1, maz_file );

      for ( z = 0 ; z < p_depth ; z++ )
         for ( y = 0 ; y < p_width ; y++ )
            for ( x = 0 ; x < p_width ; x++ )
            {
               tmptile = mazetile [ z ] [ y ] [ x ];
               fwrite ( &tmptile, sizeof ( s_Maze_tile ), 1, maz_file );
            }
      fclose ( maz_file );
   }

}

/*-------------------------------------------------------------------------*/
/*-                           Private Methods                             -*/
/*-------------------------------------------------------------------------*/

void Editor::copy_background ( void )
{
   blit ( backup, buffer, 0, 0, 0, 0, 640, 480 );
   clear_bitmap (backup);
}

void Editor::draw_map ( void )
{
   short x;
   short y;
   tiny i;
   tiny j;
   short basex;
   short basey;
   s_Maze_tile tmptile;
   byte solid;

   // draw numbers

   basex = 0;
   basey = 416;
   y = 0;

   for ( i = p_yscroll ; i < p_yscroll + 26 ; i++ )
   {
      textprintf ( backup, FNT_small, 0, basey - y, General_COLOR_TEXT, "%d", i );
      y = y + 16;
   }

   basey = 436;
   x = 18;

   for ( i = p_xscroll ; i < p_xscroll + 26 ; i++ )
   {
      textprintf ( backup, FNT_small, x, basey, General_COLOR_TEXT, "%d", i );
      x = x + 16;
   }

   // draw floor level

   if ( p_zcur == p_rclevel )
      textprintf ( backup, FNT_small, 0, 436, makecol ( 200, 200, 250 ), "RC" );

   if ( p_zcur < p_rclevel )
      textprintf ( backup, FNT_small, 0, 436, makecol ( 200, 200, 250 ),
         "F%d", ( p_zcur - p_rclevel) );

   if ( p_zcur > p_rclevel )
      textprintf ( backup, FNT_small, 0, 436, makecol ( 200, 200, 250 ),
         "B%d", ( p_rclevel - p_zcur ) );


   // draw grid
   drawing_mode(DRAW_MODE_MASKED_PATTERN, BMP_patgrid, 0, 0 );
   for ( x = 16 ; x < 448 ; x = x + 16 )
      vline ( backup, x, 16, 432, makecol ( 150, 150, 150 ) );
   for ( y = 16 ; y < 448 ; y = y + 16 )
      hline ( backup, 16, y, 432, makecol ( 150, 150, 150 ) );
   drawing_mode(DRAW_MODE_SOLID, NULL, 0, 0 );

   // draw solid

   x = 16;
   y = 416;

   for ( j = p_yscroll ; j < p_yscroll + 26 ; j++ )
   {
      for ( i = p_xscroll ; i < p_xscroll + 26 ; i++ )
      {
         if ( i < p_width && j < p_width )
            if ( ( mazetile [ p_zcur ] [ j ] [ i ]  . special
               & Maze_SPECIAL_SOLID ) > 0 )

               draw_sprite ( backup, BMP_patgrid, x, y );
         x = x + 16;
      }
      x = 16;
      y = y - 16;
   }

   // draw start position

   if  ( p_startpos.z == p_zcur )
   {
      if ( p_startpos.x >= p_xscroll && p_startpos.x <= ( p_xscroll + 26 ) )
         if ( p_startpos.y >= p_yscroll && p_startpos.y <= ( p_yscroll + 26 ) )
         {
            x = ( ( p_startpos.x - p_xscroll ) * 16 ) + 16;
            y = 416 - ( ( p_startpos.y - p_yscroll ) * 16 );
            draw_sprite ( backup, BMP_tilestart, x, y );
         }
   }

   // draw walls

   x = 16;
   y = 416;

   for ( j = p_yscroll ; j < p_yscroll + 26 ; j++ )
   {
      for ( i = p_xscroll ; i < p_xscroll + 26 ; i++ )
      {
//         if ( i < p_width && j < p_width )
//         {
            solid = mazetile [ p_zcur ] [ j ] [ i ]  . solid;

            if ( ( solid & Maze_SOLID_NORTH_MASK ) == Maze_SOLID_NORTH_WALL )
               hline ( backup, x, y, x + 15, makecol ( 200, 200, 200 ) );
            if ( ( solid & Maze_SOLID_EAST_MASK ) == Maze_SOLID_EAST_WALL )
               vline ( backup, x + 15, y, y + 15, makecol ( 200, 200, 200 ) );
            if ( ( solid & Maze_SOLID_SOUTH_MASK ) == Maze_SOLID_SOUTH_WALL )
               hline ( backup, x, y + 15, x + 15, makecol ( 200, 200, 200 ) );
            if ( ( solid & Maze_SOLID_WEST_MASK ) == Maze_SOLID_WEST_WALL )
               vline ( backup, x, y, y + 15, makecol ( 200, 200, 200 ) );

            if ( ( solid & Maze_SOLID_NORTH_MASK ) == Maze_SOLID_NORTH_DOOR )
               rotate_sprite ( backup, BMP_tiledoor, x, y, 0<<16 );
            if ( ( solid & Maze_SOLID_EAST_MASK ) == Maze_SOLID_EAST_DOOR )
               rotate_sprite ( backup, BMP_tiledoor, x, y, 64<<16 );
            if ( ( solid & Maze_SOLID_SOUTH_MASK ) == Maze_SOLID_SOUTH_DOOR )
               rotate_sprite ( backup, BMP_tiledoor, x, y, 128<<16 );
            if ( ( solid & Maze_SOLID_WEST_MASK ) == Maze_SOLID_WEST_DOOR )
               rotate_sprite ( backup, BMP_tiledoor, x, y, 192<<16 );

            if ( ( solid & Maze_SOLID_NORTH_MASK ) == Maze_SOLID_NORTH_GRID )
               rotate_sprite ( backup, BMP_tilegrid, x, y, 0<<16 );
            if ( ( solid & Maze_SOLID_EAST_MASK ) == Maze_SOLID_EAST_GRID )
               rotate_sprite ( backup, BMP_tilegrid, x, y, 64<<16 );
            if ( ( solid & Maze_SOLID_SOUTH_MASK ) == Maze_SOLID_SOUTH_GRID )
               rotate_sprite ( backup, BMP_tilegrid, x, y, 128<<16 );
            if ( ( solid & Maze_SOLID_WEST_MASK ) == Maze_SOLID_WEST_GRID )
               rotate_sprite ( backup, BMP_tilegrid, x, y, 192<<16 );
  //       }
         x = x + 16;

      }
      x = 16;
      y = y - 16;
   }

   // draw cursor

   x = ( ( p_xcur - p_xscroll ) * 16 ) + 16;
   y = 416 - ( ( p_ycur - p_yscroll ) * 16 );
   draw_sprite ( backup, BMP_curtile, x, y );
   

}

void Editor::draw_detailed_tile ( void )
{
   tiny i;
   byte mask = 0;
   short x = 0;
   short y = 0;

   // draw walls
   for ( i = 0 ; i < 4; i++ )
   {
      switch ( i )
      {
         case 0 : x = 540; y = 24; break;
         case 1 : x = 590; y = 74; break;
         case 2 : x = 540; y = 124; break;
         case 3 : x = 490; y = 74; break;
      }
      switch ( p_curtile.solid[i] )
      {
         case 1 :
            textout_centre ( backup, FNT_small, "Wall", x, y, General_COLOR_TEXT );
         break;
         case 2 :
            textout_centre ( backup, FNT_small, "Grid", x, y, General_COLOR_TEXT );
         break;
         case 3 :
            textout_centre ( backup, FNT_small, "Door", x, y, General_COLOR_TEXT );
         break;
      }
   }

   textprintf ( backup, FNT_small, 440, 380, General_COLOR_TEXT,
      "Texture Set ID :      %d", p_curtile.tilesetid );
   textprintf ( backup, FNT_small, 440, 396, General_COLOR_TEXT,
      "Wall Masked tex ID :  %d", p_curtile.walltex );
   textprintf ( backup, FNT_small, 440, 412, General_COLOR_TEXT,
      "Floor Masked tex ID : %d", p_curtile.floortex );
   textprintf ( backup, FNT_small, 440, 428, General_COLOR_TEXT,
      "Object image ID :     %d", p_curtile.objectimg );
   textprintf ( backup, FNT_small, 440, 444, General_COLOR_TEXT,
      "Event ID :            %d", p_curtile.event );

   y = 320;
   mask = 8;
   for ( i = 0 ; i < 5; i++)
   {
      if ( ( p_curtile.special_tech & mask ) > 0 )
         textout ( backup, FNT_small, STR_EDT_SPECIAL_TECH [i], 440, y,
         General_COLOR_TEXT );
      y += 12;
      mask = mask << 1;
   }
   

}

void Editor::read_curtile ( void /*s_Maze_tile mtile*/ )
{
   s_Maze_tile mtile = mazetile [p_zcur][p_ycur][p_xcur];

   p_curtile.solid [0] = (mtile.solid & Maze_SOLID_NORTH_MASK) >> 6;
   p_curtile.solid [1] = (mtile.solid & Maze_SOLID_EAST_MASK) >> 4;
   p_curtile.solid [2] = (mtile.solid & Maze_SOLID_SOUTH_MASK) >> 2;
   p_curtile.solid [3] = (mtile.solid & Maze_SOLID_WEST_MASK);
   
   p_curtile.special_tech = (mtile.special & Maze_SPECIAL_TECH_MASK);
   p_curtile.special_fill = (mtile.special & Maze_SPECIAL_FILL_MASK);
   p_curtile.masktex = (mtile.special & ( Maze_WALL_MTEX_MASK + Maze_FLOOR_MTEX_MASK));
   p_curtile.object_position = (mtile.texture & Maze_OBJECT_MASK) >> 6;
   p_curtile.tilesetid = (mtile.texture & Maze_TEXSET_MASK);
   p_curtile.walltex = mtile.walltex;
   p_curtile.floortex = mtile.floortex;
   p_curtile.objectimg = mtile.objectimg;
   p_curtile.event = mtile.event;


}

void Editor::write_curtile ( void /*s_Maze_tile &mtile*/ )
{
   s_Maze_tile mtile;

   mtile.solid = (p_curtile.solid [0] << 6) + (p_curtile.solid [1] << 4)
      + (p_curtile.solid [2] << 2) + p_curtile.solid [3];
   mtile.special = p_curtile.special_tech + p_curtile.special_fill;
   mtile.texture = p_curtile.masktex + ( p_curtile.object_position << 6 )
      + p_curtile.tilesetid;
   mtile.walltex = p_curtile.walltex;
   mtile.floortex = p_curtile.floortex;
   mtile.objectimg = p_curtile.objectimg;
   mtile.event = p_curtile.event;

   mazetile [p_zcur][p_ycur][p_xcur] = mtile;
}


/*
   notes on work to do that should normaly be written on paper.

the grid icon must be thiner
Command : Add various view type : Special, fill, texture, masktex, item
   Or detailed view ( larger square with texture, item in it.
Command : Add one way wall door finder, or simple viewer
Launch demo view ( check with maze, drop some operationality and no combat)

*/
