/***************************************************************************/
/*                                                                         */
/*                           C O N F I G . C P P                           */
/*                            Class source code                            */
/*                                                                         */
/*     Content : Class Config source code                                  */
/*     Programmer : Eric PIetrocupo                                        */
/*     Starting Date : May 20th, 2002                                      */
/*                                                                         */
/***************************************************************************/

#include <general.h>
#include <stdio.h>
//#include <stdlib.h>
//#include <time.h>
#include <allegro.h>
//#include <string.h>
//#include <datafile.h>
//#include <datmacro.h>
#include <system.h>
//#include <init.h>
//#include <menu.h>
#include <option.h>
//#include <screen.h>
//#include <dbdata.h>
//#include <dbtag.h>
//#include <database.h>
//#include <dbobject.h>
#include <ddt.h>
#include <dbdef.h>
/*#include <item.h>
#include <armor.h>
#include <weapon.h>
#include <shield.h>
#include <accesory.h>
#include <expandbl.h>*/
//#include <list.h>
#include <opponent.h>
#include <charactr.h>
//#include <monster.h>
#include <party.h>
#include <player.h>
//#include <game.h>
//#include <city.h>
#include <maze.h>
//#include <adventur.h>
//#include <camp.h>
#include <config.h>
//#include <draw.h>
//#include <dialog.h>
//#include <combat.h>
#include <window.h>
#include <winempty.h>
#include <wintitle.h>

/*-------------------------------------------------------------------------*/
/*-                      Constructor & Destructor                         -*/
/*-------------------------------------------------------------------------*/

Config::Config ( void )
{
   reset ();

}

Config::~Config ( void )
{

}

/*-------------------------------------------------------------------------*/
/*-                           Property Methods                            -*/
/*-------------------------------------------------------------------------*/

void Config::set ( tiny configID, tiny value )
{
   p_value [ configID ] = value;
}

tiny Config::get ( tiny configID )
{
   return ( p_value [ configID ] );
}

/*-------------------------------------------------------------------------*/
/*-                              Methods                                  -*/
/*-------------------------------------------------------------------------*/

void Config::start ( void )
{
   tiny i;
   
   Option opt_config;
   
//   opt_config.title ("Game Configuration");

   opt_config.add_item ("Textured Polygon    ", "  Yes   ", "   No   ",
      "", "", "", p_value [ Config_TEXTURE ] );
   opt_config.add_item ("Polygon Rendering   ", "Perspec.", " Affine ",
      "", "", "", p_value [ Config_RENDERING ] );
   opt_config.add_item ("Polygon Shading     ", "  Yes   ", "   No   ",
      "", "", "", p_value [ Config_SHADING ] );
   opt_config.add_item ("Transparent Tint    ", "  Yes   ", "   No   ",
      "", "", "", p_value [ Config_TRANSPARENCY ] );
   opt_config.add_item ("Floor & Ceiling     ", "  Yes   ", "   No   ",
      "", "", "", p_value [ Config_FLOOR_CEILING ] );
   opt_config.add_item ("Display Key Usage   ", "  Yes   ", "   No   ",
      "", "", "", p_value [ Config_KEY_DISPLAY ] );
   opt_config.add_item ("Display Instant Help", "  Yes   ", "   No   ",
      "", "", "", p_value [ Config_HELP_DISPLAY ] );
   opt_config.add_item ("Music Volume        ", "  Mute  ", "  Low   ",
      " Medium ", "  High  ", " MAX  ", p_value [ Config_MUSIC_VOLUME ] );
   opt_config.add_item ("Sound Volume        ", "  Mute  ", "  Low   ",
      " Medium ", "  High  ", " MAX  ", p_value [ Config_SOUND_VOLUME ] );
   opt_config.add_item ("Cancel/Select Key   ", " A / Z  ", " Q / W  ",
      " Z / X  ", "", "", p_value [ Config_BASIC_KEY ] );
   opt_config.add_item ("Display Party Bar   ", "  Yes   ", "   No   ",
      "", "", "", p_value [ Config_DISPLAY_PARTY ] );
   opt_config.add_item ("Display Spell Icons ", "  Yes   ", "   No   ",
      "", "", "", p_value [ Config_DISPLAY_SPELL ] );
   opt_config.add_item ("Display Maze Icons  ", "  Yes   ", "   No   ",
      "", "", "", p_value [ Config_DISPLAY_SPECIAL ] );
   opt_config.add_item ("Window Border Type  ", " Thick  ", "  Thin  ",
      " Double ", "  Flat  ", "  None  ", p_value [ Config_WINDOW_BORDER ] );
   opt_config.add_item ("Animations          ", " Yes  ", "  No  ",
      "", "", "", p_value [ Config_ANIMATION ] );
   opt_config.add_item ("Window Background   ", "UniColor", "Textured",
      "", "", "", p_value [ Config_WINDOW_BACKGROUND ] );
   opt_config.add_item ("Window Texture      ", " Granite ", " Forest ",
      " Water  ", " Purple ", " Earth  ", p_value [ Config_WINDOW_TEXTURE ] );
   opt_config.add_item ("Window Color        ", " Black  ", " Green  ",
      "  Blue  ", " Purple ", " Ocean  ", p_value [ Config_WINDOW_COLOR ] );

   opt_config.quit ("Exit");

   WinEmpty wemp_background;
   WinTitle wttl_title ("Game Options");
   
   Window::instruction ( 320, 460, Window_INSTRUCTION_MENU +
      Window_INSTRUCTION_SWITCH + Window_INSTRUCTION_CANCEL );

   Window::draw_all();

//   draw_border ( 0 , 0 , 640, 480 , General_COLOR_BORDER );

   opt_config.show ( 10, 40 );

   for ( i = 0 ; i < Config_NB_MAX_CONFIG ; i++ )
      p_value [ i ] = opt_config.selected ( i );

   initialise ();
}

void Config::reset ( void )
{
   p_value [ Config_TEXTURE ] = Config_TEX_YES;
   p_value [ Config_RENDERING ] = Config_REN_PTEX;
   p_value [ Config_SHADING ] =  Config_SHD_YES;
   p_value [ Config_TRANSPARENCY ] = Config_TRS_YES;
   p_value [ Config_FLOOR_CEILING ] = Config_FAC_YES;
   p_value [ Config_KEY_DISPLAY ] = Config_KEY_YES;
   p_value [ Config_HELP_DISPLAY ] = Config_HLP_YES;
   p_value [ Config_MUSIC_VOLUME ] = Config_MUS_MEDIUM;
   p_value [ Config_SOUND_VOLUME ] = Config_SND_MEDIUM;
   p_value [ Config_BASIC_KEY ] = Config_BKY_AZ;
   p_value [ Config_DISPLAY_PARTY ] = Config_PAR_YES;
   p_value [ Config_DISPLAY_SPELL ] = Config_SPL_YES;
   p_value [ Config_DISPLAY_SPECIAL ] = Config_SPC_YES;
   p_value [ Config_WINDOW_BORDER ] = Config_WBD_THICK;
   p_value [ Config_ANIMATION ] = Config_ANI_YES;
   p_value [ Config_WINDOW_BACKGROUND ] = Config_WBG_TEXTURE;
   p_value [ Config_WINDOW_TEXTURE ] = Config_WTX_GRANITE;
   p_value [ Config_WINDOW_COLOR ] = Config_WCO_BLACK;
}

void Config::initialise ( void )
{
   configure_volume ();
   configure_key ();
   configure_maze ();
   configure_window();
}

void Config::load ( void )
{
   FILE *Config_file;
   s_Config_file filebuffer;
   tiny i;

   if ( exists ("wizardry.cfg") != 0 )
   {
      Config_file = fopen ("wizardry.cfg","rb");

      if ( Config_file != NULL )
      {
         fread ( &filebuffer, sizeof ( s_Config_file ), 1, Config_file );

         for ( i = 0 ; i < Config_NB_MAX_CONFIG ; i++ )
            p_value [ i ] = filebuffer.f_value [ i ];

      // refresh data ofoption engine
//      for ( i = 0 ; i < Config_NB_CONFIG ; i++ )
//         opt_config.selected ( i , p_value [ i ] );
         
      }

      fclose ( Config_file );
   }
}

void Config::save ( void )
{
   FILE *Config_file;
   s_Config_file filebuffer;
   tiny i;

   Config_file = fopen ("wizardry.cfg","wb");

   for ( i = 0 ; i < Config_NB_MAX_CONFIG ; i++ )
      filebuffer.f_value [ i ] = p_value [ i ];

   fwrite ( &filebuffer, sizeof ( s_Config_file ), 1, Config_file );

   fclose ( Config_file );
}


/*-------------------------------------------------------------------------*/
/*-                           Private Methods                             -*/
/*-------------------------------------------------------------------------*/

void Config::configure_volume ( void )
{
   short svalue = 0;
   short mvalue = 0;

   if ( p_value [ Config_MUSIC_VOLUME ] > 0 )
      mvalue = 50 + p_value [ Config_MUSIC_VOLUME ] * 50;
   else
      mvalue = 0;

   if ( p_value [ Config_SOUND_VOLUME ] > 0 )
      svalue = 50 + p_value [ Config_SOUND_VOLUME ] * 50;
   else
      svalue = 0;

   set_volume ( svalue, mvalue );

}

void Config::configure_key ( void )
{

   switch ( p_value [ Config_BASIC_KEY ] )
   {
      case Config_BKY_AZ :
         CANCEL_KEY = KEY_A;
         SELECT_KEY = KEY_Z;
      break;

      case Config_BKY_QW :
         CANCEL_KEY = KEY_Q;
         SELECT_KEY = KEY_W;
      break;

      case Config_BKY_ZX :
         CANCEL_KEY = KEY_Z;
         SELECT_KEY = KEY_X;
      break;
   }

}

void Config::configure_maze ( void )
{
   byte tmpval;

   switch ( p_value [ Config_TEXTURE ] )
   {
      case Config_TEX_YES :
         switch ( p_value [ Config_RENDERING ] )
         {
            case Config_REN_PTEX :
               switch ( p_value [ Config_SHADING ] )
               {
                  case Config_SHD_YES :
                     maze.polytype ( POLYTYPE_PTEX_LIT );
                     maze.mask_polytype ( POLYTYPE_PTEX_MASK_LIT );
                     maze.adjust_color ( false );
                  break;

                  case Config_SHD_NO :
                     maze.polytype ( POLYTYPE_PTEX );
                     maze.mask_polytype ( POLYTYPE_PTEX_MASK );
                     maze.adjust_color ( false );
                  break;
               }
            break;

            case Config_REN_ATEX :
               switch ( p_value [ Config_SHADING ] )
               {
                  case Config_SHD_YES :
                     maze.polytype ( POLYTYPE_ATEX_LIT );
                     maze.mask_polytype ( POLYTYPE_ATEX_MASK_LIT );
                     maze.adjust_color ( false );
                  break;

                  case Config_SHD_NO :
                     maze.polytype ( POLYTYPE_ATEX );
                     maze.mask_polytype ( POLYTYPE_ATEX_MASK );
                     maze.adjust_color ( false );
                  break;
               }
            break;
         }
      break;

      case Config_TEX_NO :
         switch ( p_value [ Config_SHADING ] )
         {
            case Config_SHD_YES :
               maze.polytype ( POLYTYPE_GRGB );
               maze.mask_polytype ( POLYTYPE_PTEX_MASK_LIT );
               maze.adjust_color ( true );
            break;

            case Config_SHD_NO :
               maze.polytype ( POLYTYPE_FLAT );
               maze.mask_polytype ( POLYTYPE_PTEX_MASK );
               maze.adjust_color ( true );
            break;
        }
      break;
   }

   switch ( p_value [ Config_TRANSPARENCY ] )
   {
      case Config_TRS_YES :
         maze.transparency ( true );
      break;

      case Config_TRS_NO :
         maze.transparency ( false );
      break;
   }

   // set display
   tmpval = 0;

   if ( p_value [ Config_DISPLAY_PARTY ] == Config_PAR_YES )
      tmpval = tmpval + Maze_DISPLAY_PARTY;
      
   if ( p_value [ Config_DISPLAY_SPELL ] == Config_SPL_YES )
      tmpval = tmpval + Maze_DISPLAY_SPELL;
      
   if ( p_value [ Config_DISPLAY_SPECIAL ] == Config_SPC_YES )
      tmpval = tmpval + Maze_DISPLAY_SPECIAL;

   maze.display ( tmpval );
   
}


void Config::configure_window ( void )
{
   Window::border_type ( p_value [ Config_WINDOW_BORDER ] );
   Window::background_color  ( p_value [ Config_WINDOW_COLOR ] );
   Window::background_texture ( p_value [ Config_WINDOW_TEXTURE ] );
   Window::background_mode ( p_value [ Config_WINDOW_BACKGROUND ] );

   // add color setting
}

