/***************************************************************************/
/*                                                                         */
/*                         C O M B A T . C P P                             */
/*                          Class Source Code                              */
/*                                                                         */
/*     Content : Class Combat source code                                  */
/*     Programmer : Eric Pietrocupo                                        */
/*     Starting Date : July 2nd, 2002                                      */
/*                                                                         */
/***************************************************************************/

#include <allegro.h>
#include <general.h>
#include <stdio.h>
//#include <stdlib.h>
//#include <time.h>
#include <string.h>
#include <datafile.h>
#include <advdatf.h>
#include <datmacro.h>
#include <system.h>
//#include <init.h>
#include <menu.h>
//#include <option.h>
//#include <screen.h>
//#include <dbdata.h>
//#include <dbtag.h>
//#include <database.h>
//#include <dbobject.h>
#include <ddt.h>
#include <dbdef.h>
#include <item.h>
//#include <armor.h>
#include <weapon.h>
//#include <shield.h>
//#include <accesory.h>
//#include <expandbl.h>
//#include <list.h>
#include <race.h>
#include <opponent.h>
#include <charactr.h>
#include <ennemy.h>
#include <party.h>
#include <player.h>
#include <game.h>
#include <account.h>
//#include <city.h>
#include <maze.h>
//#include <adventur.h>
//#include <camp.h>
//#include <config.h>
//#include <draw.h>
//#include <dialog.h>
#include <combat.h>
#include <window.h>
#include <windata.h>
#include <winempty.h>
#include <winmenu.h>
#include <wdatproc.h>
#include <wintitle.h>
#include <winmessa.h>
#include <winquest.h>

/*-------------------------------------------------------------------------*/
/*-                      Constructors and Destructors                     -*/
/*-------------------------------------------------------------------------*/

Combat::Combat ( void )
{
   clear();
}

Combat::~Combat ( void )
{
   clear();
}

/*-------------------------------------------------------------------------*/
/*-                           Property Methods                            -*/
/*-------------------------------------------------------------------------*/

/*tiny Combat::nb_character ( void )
{
   return ( p_nb_character );
}

tiny Combat::nb_ennemy ( void )
{
   return ( p_nb_ennemy );
} */

/*-------------------------------------------------------------------------*/
/*-                               Methods                                 -*/
/*-------------------------------------------------------------------------*/

/*void Combat::add_character ( DBTag character )
{
   if ( p_nb_character < 6 )
   {
      p_character [ p_nb_character ] = character;
      p_nb_character++;
   }
} */

void Combat::add_character_party ( DBTag party )
{
   Party tmparty;
   tiny i;

   p_char_party = party;
   tmparty.DBselect ( party );
   
   i = 0;
   while ( i < tmparty.nb_character() )
   {
      p_character [ i ].DBselect ( tmparty.character ( i ) );
      i++;
   }
   p_nb_character = i;
}
/*
void Combat::add_ennemy ( DBTag ennemy )
{
   if ( p_nb_ennemy < 6 )
   {
      p_ennemy [ p_nb_ennemy ] = ennemy;
      p_nb_ennemy++;
   }
} */

void Combat::add_ennemy_party ( DBTag party )
{

   Party tmparty;
   tiny i;

   p_enmy_party = party;
   tmparty.DBselect ( party );
   
   i = 0;
   while ( i < tmparty.nb_character() )
   {
      p_ennemy [ i ].DBselect ( tmparty.character ( i ) );
      i++;
   }
   p_nb_ennemy = i;
   
}

/*void Combat::save_opponents ( void )
{



} */

void Combat::reselect_opponents ( void )
{
   tiny i;
   Party tmparty;
   p_nb_character = 0;
   p_nb_ennemy = 0;

   tmparty.DBselect ( p_char_party );
   
   i = 0;
   while ( i < tmparty.nb_character() )
   {
      p_character [ i ].DBselect ( tmparty.character ( i ) );
      i++;
   }
   p_nb_character = i;

   tmparty.DBselect ( p_enmy_party );

   i = 0;
   while ( i < tmparty.nb_character() )
   {
      p_ennemy [ i ].DBselect ( tmparty.character ( i ) );
      i++;
   }
   p_nb_ennemy = i;

}

void Combat::clear ( void )
{
   tiny i;

   p_nb_character = 0;
   p_nb_ennemy = 0;
   p_char_party.number(0);
   p_enmy_party.number(0);

   for ( i = 0 ; i < p_nb_character ; i++ )
   {
      p_character [ i ] . combatstr ("");
//      p_character [ i ].number(0);
//      p_ennemy [ i ].number(0);
   }
}

void Combat::add_reward ( void )
{
   tiny i;
   tiny divider = 0;
   int totalgold = 0;
   int totalexp = 0;
   char tmpstr [ 200 ];

   for ( i = 0 ; i < p_nb_ennemy ; i++ )
   {
      if ( p_ennemy [ i ] . status () != Opponent_STATUS_DISPELLED )
      {
         totalgold += p_ennemy [ i ] . gold();
         totalexp += p_ennemy [ i ] . reward_exp();
      }
   }

   for ( i = 0 ; i < p_nb_character ; i++ )
   {
      if ( p_character [ i ] . status () == Opponent_STATUS_ALIVE )
         divider++;
   }

   if ( divider == 0 )
      divider = 1;

   totalexp = totalexp / divider;
   totalgold = totalgold / divider;

   for ( i = 0 ; i < p_nb_character ; i++ )
   {
      if ( p_character [ i ] . status () == Opponent_STATUS_ALIVE )
      {
         p_character [ i ] . gain_exp ( totalexp );
         p_character [ i ] . gain_gold ( totalgold );
      }
   }

   sprintf ( tmpstr ,
      "All characters alive gain \n %d Gold Pieces and %d experience Points",
      totalgold, totalexp );

   load_backup_screen();
   WinMessage wmsg_reward ( tmpstr );
   Window::show_all();
   
}

void Combat::show_cimetary ( void )
{
   tiny i;
   short x [ 6 ] = {128, 256, 384, 128, 256, 384 };
   short y [ 6 ] = { 40, 40, 40, 200, 200, 200 };

   play_music_track ( System_MUSIC_w3death, false );

   for ( i = 0 ; i < p_nb_character ; i++ )
   {
      draw_sprite ( buffer, BMP_tomb, x [ i ], y [ i ] );
      textprintf ( buffer, FNT_print, x [ i ], y [ i ] + 128 , General_COLOR_TEXT,
         "%s", p_character [ i ] . name() );
   }

   textout_centre ( buffer, FNT_elgar32, "Helas, your characters have been defeated!",
      320, 0, General_COLOR_TEXT );

   textout_centre ( buffer, FNT_print, "Push A button to continue!",
      320, 350, General_COLOR_TEXT );

   textout_centre ( buffer, FNT_small, "The button I mean is not RESET, it is the Select key.",
      320, 368, General_COLOR_TEXT );

   copy_buffer();
   while ( ( readkey() >> 8 ) != SELECT_KEY );
}

/*
void Combat::activesort_characters ( void )
{
   int i;
   int j;
//   DBTag tmptag;
   Character tmpchar;

   for ( i = 0 ; i < p_nb_character - 1 ; i++ )
   {
//      if ( p_character [ i ] != 0 )
//      {
//         tmpchar.DBselect ( p_character [ i ] );
         if ( p_character [ i ].is_active() == false )
         {
            tmpchar = p_character [ i ];
            p_character [ i ] = p_character [ i + 1 ];
            p_character [ i + 1 ] = tmpchar;
         }
//      }
   }
}

void Combat::activesort_ennemies ( void )
{
   int i;
   int j;
//   DBTag tmptag;
   Ennemy tmpenmy;

   for ( i = 0 ; i < 5 ; i++ )
   {
//      if ( p_ennemy [ i ] != 0 )
//      {
//         tmpenmy.DBselect ( p_ennemy [ i ] );
         if ( p_ennemy [ i ].is_active() == false )
         {
            tmpenmy = p_ennemy [ i ];
            p_ennemy [ i ] = p_ennemy [ i + 1 ];
            p_ennemy [ i + 1 ] = tmpenmy;
         }
//      }
   }
}*/


/*
void Combat::remove_character ( tiny index )
{
   tiny i;

   for ( i = index ; i < p_nb_character ; i++ )
      p_character [ i ] = p_character [ i + 1 ];

   p_nb_character--;
}

void Combat::remove_ennemy ( tiny index )
{
   tiny i;

   for ( i = index ; i < p_nb_ennemy ; i++ )
      p_ennemy [ i ] = p_ennemy [ i + 1 ];

   p_nb_ennemy--;

} */

tiny Combat::start ( void )
{
   bool end_combat = false;
   bool start_round;
   tiny answer;
   tiny answer2;
   tiny i;
   tiny j;
   tiny k;
   s_Combat_action cact [ 12 ];
   s_Combat_action swapcact;
   tiny nb_action;
//   string tmpstr;
   char strtitle [ 81 ];
   Party eparty;
   Party cparty;
   tiny tmpvar;
   tiny commandID [ 12 ];
   tiny cmdidx;
   bool tmpmask = false;
   bool cmdcanceled;
   bool ennemyalive;
   bool characteralive;
   tiny returnval = Combat_VICTORY;
   tiny targetrange = 6;
   tiny rndval;
   tiny nb_active;
   s_Opponent_stat stat;
   tiny nb_char_alive;


   play_music_track ( System_MUSIC_w1fight );

//   eparty.DBselect ( p_enmy_party );
//   cparty.DBselect ( p_char_party );


   tmpvar = 0;
   while ( end_combat == false )
   {
      nb_action = 0;
      // read character commnads
      start_round = true;

      eparty.DBselect ( p_enmy_party );
      cparty.DBselect ( p_char_party );

      WinData<Party> wdat_enmy_bar ( WDatProc_ennemy_bar, eparty ,
         WDatProc_POSITION_ENNEMY_BAR );
      WinData<Party> wdat_char_bar ( WDatProc_party_bar, cparty ,
         WDatProc_POSITION_PARTY_BAR );
         
//      wdat_enmy_bar.preshow();
//      wdat_char_bar.preshow();

/*      wdat_char_bar.refresh();
      wdat_enmy_bar.refresh();*/
      
      i = 0;
      while ( i < cparty.nb_character() )
      {
         Menu mnu_ennemy;
         Menu mnu_character;
         Menu mnu_command;
         cmdidx = 0;
         cmdcanceled = false;
         


         if ( p_character [ i ].is_active() == true )
         {
            // build character command list
            sprintf ( strtitle, "%s 's Commands", p_character [ i ].name() );

            mnu_command.title ( strtitle );

            for ( k = 0 ; k < Combat_COMMAND_SIZE ; k++ )
            {
               if ( COMBAT_COMMAND [ k ] . requirement == 0 )
               {
                  tmpmask = false;
                  if ( COMBAT_COMMAND [ k ] . skill == 1 )
                     tmpmask = true;

                  if ( tmpmask != true )
                  {
                     mnu_command.add_item ( COMBAT_COMMAND [ k ] . name , tmpmask );
                     commandID [ cmdidx ] = k;
                     cmdidx++;
                  }
               }
               else
               {
                  switch ( COMBAT_COMMAND [ k ] . requirement )
                  {
                     case Combat_CMDREQ_NOT_FIRST :
                        if ( i > 0 )
                        {
                           mnu_command.add_item ( COMBAT_COMMAND [ k ] . name );
                           commandID [ cmdidx  ] = k;
                           cmdidx++;
                        }
                     break;
                     case Combat_CMDREQ_TARGET :
                        p_character [ i ].eval_stat_all();
                        stat = p_character [ i ].stat();
                        // hide fight command for melee from back row
                        if ( k == Combat_COMMAND_FIGHT && i >= 3 &&
                           stat.range == Weapon_RANGE_MELEE )
                        {
      //                     mnu_command.add_item ( COMBAT_COMMAND [ k ] . name, true );
                        }
                        else
                        {
                           mnu_command.add_item ( COMBAT_COMMAND [ k ] . name );
                           commandID [ cmdidx ] = k;
                           cmdidx++;
                        }
                     break;
                     case Combat_CMDREQ_FIRST :
                        if ( i == 0 )
                        {
                           mnu_command.add_item ( COMBAT_COMMAND [ k ] . name );
                           commandID [ cmdidx  ] = k;
                           cmdidx++;
                        }
                     break;                     
                  }
               }
            }

            wdat_char_bar.refresh();
            WinMenu wmnu_command ( mnu_command, 400, 0 );
            Window::instruction ( 200, 109 );

            // drawing
//            load_backup_screen();
            draw_ennemy();
            answer = Window::show_all();

//            make_screen_shot ("Combshot.bmp");//@@

            if ( answer != -1 && commandID [ answer ] != Combat_COMMAND_PREVIOUS
               && commandID [ answer ] != Combat_COMMAND_RUN )
            {

               cact [ nb_action ] . actor_type = Combat_ACTOR_TYPE_CHARACTER;
               cact [ nb_action ] . actor_ID = i;
               cact [ nb_action ] . command = commandID [ answer ];
               cact [ nb_action ] . initiative = p_character[i].initiative();


               // target selection
               if ( COMBAT_COMMAND [ cact [ nb_action ] . command ] . requirement
                  == Combat_CMDREQ_TARGET )
               {
                  // check target attack range according to weapon
                  p_character [ i ].eval_stat_all();
                  stat = p_character [ i ].stat();
                  targetrange = 0;
                  if ( cact [ nb_action ] . command == Combat_COMMAND_FIGHT )
                  {
                     if ( i < 3 )
                     {
                        switch ( stat.range )
                        {
                           case Weapon_RANGE_MELEE :
                              targetrange = 3;
                           break;
                           case Weapon_RANGE_SHORT :
                              targetrange = 6;
                           break;
                           case Weapon_RANGE_LONG :
                              targetrange = 6;
                           break;
                           default :
                              targetrange = 1;
                           break;
                        }
                     }
                     else
                     {
                        switch ( stat.range )
                        {
                           case Weapon_RANGE_MELEE :
                              targetrange = 0;
                           break;
                           case Weapon_RANGE_SHORT :
                              targetrange = 3;
                           break;
                           case Weapon_RANGE_LONG :
                              targetrange = 6;
                           break;
                           default :
                              targetrange = 1;
                           break;
                        }
                        
                     }
                  }
                  else
                     targetrange = 6;

                  for ( j = 0 ; j < p_nb_ennemy ; j++ )
                  {
                     if ( j < targetrange )
                     {
                        if ( p_ennemy [ j ].status() == Opponent_STATUS_ALIVE )
                           mnu_ennemy.add_item ( "" );
                        else
                           mnu_ennemy.add_item ( "", true );
                     }
                  }
                  
//                  load_backup_screen();
                  draw_ennemy();
                  Window::draw_all();

                  answer2 = mnu_ennemy.show ( 6, 6, 0 );

                  if ( answer2 == -1 )
                     cmdcanceled = true;
                  else
                     cact [ nb_action ] . target = answer2;
               }
               else
                  cact [ nb_action ] . target = 0;

               if ( cmdcanceled == false )
               {
                  p_character [ i ] .combatstr ( COMBAT_COMMAND [ commandID [ answer ] ] . name );
                  p_character [ i ] .DBupdate();
                  nb_action++;
                  i++;
               }
//               p_character[ i ].combatstr ( COMBAT_COMMAND [ commandID [ answer ] ] . name );
            }
            else
            {
               if ( commandID [ answer ] == Combat_COMMAND_RUN )
               {
                  WinQuestion wqst_run ("Are you sure you want to run from this battle ?");
                  answer = Window::show_all();
                  wqst_run.hide();
                     
                  if ( answer == WinQuestion_ANSWER_YES )
                  {
                     rndval = rnd ( 10 );
                     nb_active = 0;
                     i = 10;
                     for ( j = 0 ; j < p_nb_ennemy ; j++ )
                     {
                        if ( p_ennemy [ j ] . is_active () == true )
                           nb_active += 1;
                     }
                     if ( rndval > nb_active )
                     {
                        WinMessage wmsg_run_success ("You escaped Successfully !");
                        Window::show_all();
                        start_round = false;
                        end_combat = true;
                     }
                     else
                     {
                        WinMessage wmsg_run_fail ("Escape is a failure");
                        Window::show_all();
                     }
                  }
               }
               if ( commandID [ answer ] == Combat_COMMAND_PREVIOUS )
               {
                     p_character [ i ].combatstr (" ");
                     p_character [ i ].DBupdate();
//                     cparty.DBupdate();
                     wdat_char_bar.refresh();
                     i--;
                     if ( i < 0 )
                        i = 0;
                     nb_action--;
                     if ( nb_action < 0 )
                        nb_action = 0;
               }
            }
         }
         else
         {
            i++;
         }

         
      }

      wdat_char_bar.refresh();
      //?? change, draw character actions
      if ( i != 10 )
      {
         WinQuestion wmsg_confirm ("Do you accept these commands ?", 320, 200);

   //      load_backup_screen();
         draw_ennemy();
         answer = Window::show_all();
         wmsg_confirm.hide();

         if ( answer == WinQuestion_ANSWER_NO )
         {
            start_round = false;
            for ( i = 0 ; i < p_nb_character ; i++ )
            {
               p_character [ i ].combatstr ("");
               p_character [ i ].DBupdate();
            }
            wdat_char_bar.refresh();
         }
      }

      

      if ( start_round == true )
      {
         // Eval all stat
         for ( i = 0 ; i < p_nb_ennemy ; i++ )
            p_ennemy [ i ].eval_stat_all();

         for ( i = 0 ; i < p_nb_character ; i++ )
            p_character [ i ].eval_stat_all();

         //Interpret annemy AI ?? temporary script

         nb_char_alive = 0;
         for ( i = 0 ; i < p_nb_character ; i++ )
         {
            if ( p_character [ i ] . status () == Opponent_STATUS_ALIVE )
               nb_char_alive++;
         }

         for ( i = 0 ; i < p_nb_ennemy ; i++ )
         {
            if ( p_ennemy[ i ].is_active() == true )
            {
               cact [ nb_action ] . actor_type = Combat_ACTOR_TYPE_ENNEMY;
               cact [ nb_action ] . actor_ID = i;
               cact [ nb_action ] . initiative = p_ennemy[i].initiative();

               //?? temporary AI
               p_ennemy [ i ].eval_stat_all();
               stat = p_ennemy [ i ] . stat();
               if ( i < 3 )
               {
                  switch ( stat.range )
                  {
                     case Weapon_RANGE_MELEE :
                        targetrange = 3;
                     break;
                     case Weapon_RANGE_SHORT :
                     case Weapon_RANGE_LONG :
                        targetrange = 6;
                     break;
                  }
               }
               else
               {
                  switch ( stat.range )
                  {
                     case Weapon_RANGE_MELEE :
                        targetrange = 0;
                     break;
                     case Weapon_RANGE_SHORT :
                        targetrange = 3;
                     break;
                     case Weapon_RANGE_LONG :
                        targetrange = 6;
                     break;
                  }
               }

               if ( targetrange > 0 )
               {
                  //?? this AI method only attack
                  if ( targetrange > nb_char_alive )
                     targetrange = nb_char_alive;
                  cact [ nb_action ] . target = dice ( targetrange ) - 1;
                  cact [ nb_action ] . command = Combat_COMMAND_FIGHT;
               }
               else
               {
                  cact [ nb_action ] . target = -1;
                  cact [ nb_action ] . command = Combat_COMMAND_PARRY;
               }
               
               nb_action++;
            }
         }

         // modify initiative according to action

         for ( i = 0 ; i < nb_action ; i++ )
         {
            if ( cact [ i ] . command == Combat_COMMAND_PARRY )
               cact [ i ] . initiative = 100;
         }

         // Sort actions by initiative

         for ( i = 0 ; i < nb_action - 1 ; i++ )
         {
            for ( j = i + 1 ; j < nb_action ; j++ )
            {
               if ( cact [ j ] . initiative > cact [ i ] . initiative )
               {
                  swapcact = cact [ i ];
                  cact [ i ] = cact [ j ];
                  cact [ j ] = swapcact;
               }
            }
         }
         

         //Execute combat actions
         //string output;
         char strmsg [ 241 ];
         wdat_enmy_bar.hide();
//         wdat_char_bar.hide();
         

         for ( i = 0 ; i < nb_action ; i++ )
         {

            if ( cact [ i ] . actor_type == Combat_ACTOR_TYPE_CHARACTER )
            {
               if ( p_character [ cact [ i ] . actor_ID ] . is_active() == true
                  && p_ennemy [ cact [ i ] . target ].status() == Opponent_STATUS_ALIVE )
               {
                  p_character [ cact [ i ] . actor_ID ] . combat_action
                  ( cact [ i ] . command, 0, strmsg, p_ennemy [ cact [ i ] . target ] );
               }
               else
                  strcpy ( strmsg, "--");
            }
            else
            {
               if ( p_ennemy [ cact [ i ] . actor_ID ] . is_active() == true
                  && p_character [ cact [ i ] . target ].status() == Opponent_STATUS_ALIVE )
               {
                  p_ennemy [ cact [ i ] . actor_ID ] . combat_action
                  ( cact [ i ] . command, 0, strmsg, p_character [ cact [ i ] . target ] );
               }
               else
                  strcpy ( strmsg, "--");               
            }

            if ( strcmp ( strmsg, "--" ) != 0 )
            {
               WinMessage wsmg_output ( strmsg, 320, 0 );
//               load_backup_screen();
               draw_ennemy();
               Window::show_all();
            }

/*            wdat_char_bar.refresh();
            wdat_char_bar.preshow();
            wdat_enmy_bar.refresh();
            wdat_enmy_bar.preshow();*/
         }

//         WinMessage wmsg_combat ( "Combat is being executed", 320, 200 );

         wdat_enmy_bar.unhide();
         wdat_char_bar.unhide();


         //?? check for combat ending

         ennemyalive = false;

         for ( j = 0 ; j < p_nb_ennemy ; j++ )
         {
            if ( p_ennemy [ j ] . status () == Opponent_STATUS_ALIVE )
               ennemyalive = true;
         }

         characteralive = false;

         for ( j = 0 ; j < p_nb_character ; j++ )
         {
            if ( p_character [ j ] . status() == Opponent_STATUS_ALIVE )
               characteralive = true;
         }

         if ( characteralive == false )
         {
            end_combat = true;
            wdat_enmy_bar.hide();

            wdat_char_bar.refresh();
            WinTitle wttl_encounter ("Defeated !", 320, 200 );

            stop_midi();
            play_sample ( SMP_sound037, 128, 128, 1000, 0 );
            load_backup_screen();
            Window::draw_all();
            copy_buffer();
            rest ( 3000 );
            returnval = Combat_DEFEATED;
            show_cimetary();
            
         }
         else
         {
            if ( ennemyalive == false )
            {
               end_combat = true;
               wdat_enmy_bar.hide();
               WinTitle wttl_encounter ("Victory !", 320, 200 );

               play_music_track ( System_MUSIC_w1victor, false );
               load_backup_screen();
               Window::draw_all();
               copy_buffer();
               rest ( 1000 );
               returnval = Combat_VICTORY;
               add_reward ();
            }
         }

         // empy actions
         for ( i = 0 ; i < nb_action ; i++ )
         {
            cact [ i ] .actor_type = 0;
            cact [ i ] .actor_ID = 0;
            cact [ i ] .command = -1;
            cact [ i ] .initiative = 0;
            cact [ i ] .target = 0;
            cact [ i ] .value = 0;
         }

         //Update char/enmy in database

         //?? only if wdatproc select its own data
         for ( i = 0 ; i < p_nb_ennemy ; i++ )
         {
            p_ennemy[i].DBupdate();
         }

         for ( i = 0 ; i < p_nb_character ; i++ )
         {
            p_character [ i ].combatstr ("");
            p_character [ i ].DBupdate();
         }

         cparty.activesort_characters();
         eparty.activesort_characters();

         cparty.DBupdate();
         eparty.DBupdate();

         reselect_opponents();

      }
   }

   for ( i = 0 ; i < p_nb_character ; i++ )
   {
      p_character [ i ].combatstr ("");
      p_character [ i ].DBupdate();
   }

   cparty.DBupdate();

   clear();

   return ( returnval );

}

/*-------------------------------------------------------------------------*/
/*-                        Private Methods                                -*/
/*-------------------------------------------------------------------------*/

/*void Combat::draw_combat_screen ( void )
{
   Party &player_party = player.selected_party ();
   short tmpval;
   tiny height = text_height ( FNT_print );
   tiny i;

   // ennemy bar ( maybe place in another function if used by encounter
   tmpval = 12 + ( 6 * height );
   
   WinEmpty wemp_monster_list ( 0, 0, 640, tmpval ); //?? replace with windata
//   draw_border_fill ( 0, 0, 639, tmpval, General_COLOR_BORDER,
//                                                        General_COLOR_FILL );
   tmpval = 6;
   for ( i = 0 ; i < p_nb_ennemy ; i++ )
   {
      textprintf ( buffer, FNT_print, 30, tmpval, General_COLOR_TEXT,
         "%s", p_ennemy [ i ]->cname_combat() );
      tmpval = tmpval + height;
   }

   // draw party bar
   WinData<Party> wdat_party ( WDatProc_party_bar, player_party,
      WDatProc_POSITION_PARTY_BAR );
//   draw_party_bar( player_party );

   // draw monster display

   WinEmpty wemp_monster_picture ( 0, 112, 396, 244 );
//   draw_border_fill ( 0, 112, 396, 355, General_COLOR_BORDER,
//      General_COLOR_FILL );*/

/*   stretch_sprite ( buffer, BMP_monster013, 102, 141, 64, 64 );
   stretch_sprite ( buffer, BMP_monster014, 166, 141, 64, 64 );
   stretch_sprite ( buffer, BMP_monster015, 230, 141, 64, 64 );

   stretch_sprite ( buffer, BMP_monster010, 54, 173, 96, 96 );
   stretch_sprite ( buffer, BMP_monster011, 150, 173, 96, 96 );
   stretch_sprite ( buffer, BMP_monster012, 246, 173, 96, 96 );*/

/*   draw_sprite ( buffer, BMP_ennemy058, 6, 221 );
   if ( p_nb_ennemy >= 2 )
      draw_sprite ( buffer, BMP_ennemy059, 134, 221 );
   if ( p_nb_ennemy >= 3 )
      draw_sprite ( buffer, BMP_ennemy041, 262, 221 );

   // draw character menu display

//   draw_border_fill ( 400, 112, 639, 355, General_COLOR_BORDER,
//                                                        General_COLOR_FILL );

} */

void Combat::draw_ennemy ( void )
{

   tiny i;
   tiny j = 0;
   short xposfront [ 3 ] = { 32, 224, 416 };
   short xposback [ 3 ] = { 118, 256, 384 };
//   short picture [ 6 ];
   short pictureid;
   tiny nb_picture = 0;
//   Ennemy tmpenn;

/*   for ( i = 0 ; i < p_nb_ennemy ; i++ )
   {
//      tmpenn.DBselect ( party.character ( i ) );
      if ( p_ennemy [ i ] . status () == Opponent_STATUS_ALIVE )
      {
         picture [ i ] = p_ennemy [ i ].pictureID();
//         nb_picture++;
      }
   }*/

   i = p_nb_ennemy - 1;
   while ( i >= 0 )
   {
      if ( p_ennemy [ i ] . status () == Opponent_STATUS_ALIVE )
      {
         pictureid = p_ennemy [ i ].pictureID();
         if ( i < 3 )
         {
            stretch_sprite ( buffer,
               (BITMAP*) datfennemy [ BMP_ENNEMY000 + pictureid ]. dat,
               xposfront [ i  ], 160, 192, 192 );
         }
         if ( i >= 3 )
         {
            draw_sprite ( buffer,
               (BITMAP*) datfennemy [ BMP_ENNEMY000 + pictureid ]. dat,
               xposback [ i - 3 ], 120 );
         }
      }
      i--;
   }
}





