/***************************************************************************/
/*                                                                         */
/*                           C I T Y . C P P                               */
/*                                                                         */
/*     Content : Class City                                                */
/*     Programmer : Eric Pietrocupo                                        */
/*     Starting Date : March 27th, 2002                                    */
/*                                                                         */
/***************************************************************************/

#include <allegro.h>
#include <general.h>

#include <stdio.h>
//#include <stdlib.h>
//#include <time.h>

#include <string.h>
#include <datafile.h>
#include <advdatf.h>
#include <datmacro.h>
#include <system.h>
//#include <init.h>
#include <menu.h>
//#include <option.h>
#include <screen.h>
//#include <dbdata.h>
//#include <dbtag.h>
//#include <database.h>
//#include <dbobject.h>
#include <ddt.h>
#include <dbdef.h>
#include <item.h>
#include <armor.h>
#include <weapon.h>
#include <shield.h>
#include <accesory.h>
#include <expandbl.h>
#include <list.h>
#include <race.h>
#include <opponent.h>
#include <charactr.h>
//#include <monster.h>
#include <party.h>
#include <player.h>
#include <game.h>
#include <account.h>
#include <adventur.h>
#include <city.h>
#include <maze.h>
//#include <adventur.h>
//#include <camp.h>
//#include <config.h>
//#include <draw.h>
//#include <dialog.h>
//#include <combat.h>
#include <window.h>
#include <winempty.h>
#include <wintitle.h>
#include <winmenu.h>
#include <windata.h>
#include <wdatproc.h>
#include <winlist.h>
#include <winmessa.h>
#include <strmake.h>

/*-------------------------------------------------------------------------*/
/*-                      Constructor & Destructor                         -*/
/*-------------------------------------------------------------------------*/

City::City ( void )
{
   short i;
   short j;

/* to initialise
  private: string p_title; // title of the city
   private: string p_shortname;
   private: tiny p_nb_place; // number of places in the city
   private: short p_xpos; // xposition on the map
   private: short p_ypos; // yposition on the map
   private: s_City_place p_place [ City_NB_MAX_LOCATION ]; // list of places which can be visited
   private: s_City_warp p_warp [ City_NB_MAX_WARP ]; // city warping information
*/

   strcpy ( p_name, "City long name" );
   strcpy ( p_shortname, "City name" );
   p_nb_place = 0;
   p_xpos = 0;
   p_ypos = 0;
   p_type = City_TYPE_VILLAGE;

   for ( i = 0 ; i < City_NB_MAX_LOCATION ; i++ )
   {
      strcpy ( p_place [ i ].name, "Location" );
      p_place [ i ].music_track = 1;
      for ( j = 0 ; j < City_NB_MAX_SERVICE ; j++ )
         p_place [ i ].service [ j ] = -1;
   }

   for ( i = 0 ; i < City_NB_MAX_WARP ; i++ )
   {
      p_warp [ i ].type = 0;
//      p_warp.distance = 0;
      p_warp [ i ].target = 0;
      p_warp [ i ].tag.number ( 0 );
   }
   
   for ( i = 0 ; i < City_NB_MAX_ITEM ; i++ )
   {
      p_item [ i ].itemtag.number ( 0 );
      p_item [ i ].type = -1;
      p_item [ i ].quantity = 0;
   }

   p_dblength = sizeof ( dbs_City );
   p_dbtableID = DBTABLE_CITY;

/*
   p_data.title = "Abandoned city of Kondolar";

   for ( i = 0 ; i < City_NB_MAX_LOCATION ; i++ )
      for ( j = 0 ; j < City_NB_MAX_SERVICE ; j++ )
         p_data.place [ i ] . service [ j ] = -1;

   p_data.place[ 0 ].name = "Green Dragon Inn";
   p_data.place[ 0 ].service [ 0 ] = City_SERVICE_REST;
//   p_data.place[ 0 ].service [ 1 ] = City_SERVICE_RETURN;
   p_data.place[ 0 ].music_track = System_MUSIC_w2inn;

   p_data.place[ 1 ].name = "Adventurer's Guild" ;
   p_data.place[ 1 ].service [ 0 ] = City_SERVICE_HIRE;
//   p_data.place[ 1 ].service [ 1 ] = City_SERVICE_RETURN;
   p_data.place[ 1 ].music_track = System_MUSIC_w3inn;

   p_data.place[ 2 ].name = "Central Market";
   p_data.place[ 2 ].service [ 0 ] = City_SERVICE_BUY;
   p_data.place[ 2 ].service [ 1 ] = City_SERVICE_FORGE;
   p_data.place[ 2 ].service [ 2 ] = City_SERVICE_KEY;
//   p_data.place[ 2 ].service [ 3 ] = City_SERVICE_RETURN;
   p_data.place[ 2 ].music_track = System_MUSIC_w2shop;

   p_data.place[ 3 ].name ="Order of Leithbur";
   p_data.place[ 3 ].service [ 0 ] = City_SERVICE_HEAL;
   p_data.place[ 3 ].service [ 1 ] = City_SERVICE_REVIVE;
   p_data.place[ 3 ].service [ 2 ] = City_SERVICE_KNOWLEDGE;
//   p_data.place[ 3 ].service [ 3 ] = City_SERVICE_RETURN;
   p_data.place[ 3 ].music_track = System_MUSIC_w1temple;

   p_data.place[ 4 ].name = "Duvack's Tower";
   p_data.place[ 4 ].service [ 0 ] = City_SERVICE_ENCHANT;
   p_data.place[ 4 ].service [ 1 ] = City_SERVICE_IDENTIFY;
   p_data.place[ 4 ].service [ 2 ] = City_SERVICE_UNCURSE;
//   p_data.place[ 4 ].service [ 3 ] = City_SERVICE_RETURN;
   p_data.place[ 4 ].music_track = System_MUSIC_w3shop;

//   p_data.place[ 5 ].name = "Edge of Town";
//   p_data.place[ 5 ].service [ 0 ] = City_SERVICE_LANDWARP;
//   p_data.place[ 5 ].service [ 1 ] = City_SERVICE_SEAWARP;
//   p_data.place[ 5 ].service [ 2 ] = City_SERVICE_AIRWARP;
//   p_data.place[ 5 ].service [ 3 ] = City_SERVICE_MAGIKWARP;
//   p_data.place[ 5 ].service [ 4 ] = City_SERVICE_EXPLORE;
//   p_data.place[ 5 ].service [ 5 ] = City_SERVICE_RETURN;
//   p_data.place[ 5 ].music_track = System_MUSIC_w1city;

//?? maybe set by default, still allows variation according to adventure
   p_data.place[ 5 ].name = "Game Master's Den";
   p_data.place[ 5 ].service [ 0 ] = City_SERVICE_LEVELUP;
   p_data.place[ 5 ].service [ 1 ] = City_SERVICE_HOME;
   p_data.place[ 5 ].service [ 2 ] = City_SERVICE_QUIT;
//   p_data.place[ 5 ].service [ 3 ] = City_SERVICE_RETURN;
   p_data.place[ 5 ].music_track = System_MUSIC_w3tavern;

   p_data.nb_place = 6;

   for ( i = 0 ; i < City_NB_MAX_WARP ; i++ )
   {
      p_data.warp [ i ] . type = City_WARPTYPE_LAND;
      p_data.warp [ i ] . distance = 0;
      p_data.warp [ i ] . citytag . number ( 0 );
   }
   
   p_data.xpos = 100;
   p_data.ypos = 100;

   for ( i = 0 ; i < City_NB_MAX_ITEM ; i++ )
   {
      p_data.item [ i ] . itemtag . number ( 0 );
      p_data.item [ i ] . type = -1;
      p_data.item [ i ] . quantity = 0;
      p_data.item [ i ] . modifier = 0;
   }
*/
}

City::~City ( void )
{

}

/*-------------------------------------------------------------------------*/
/*-                         Property Methods                              -*/
/*-------------------------------------------------------------------------*/

/*void City::name ( string &str )
{
   p_name = str;
}

string& City::name ( void )
{
   return ( p_name );
} */

void City::name ( const char* str )
{
   strncpy ( p_name, str, 31 );
}

const char* City::name ( void )
{
   return ( p_name );
}

tiny City::nb_place ( void )
{
   return ( p_nb_place );
}

short City::xpos ( void )
{
   return ( p_xpos );
}

short City::ypos ( void )
{
   return ( p_ypos );
}

tiny City::type ( void )
{
   return ( p_type );
}

/*void City::party ( Party &party )
{
   p_party = party;
} */

/*-------------------------------------------------------------------------*/
/*-                             Methods                                   -*/
/*-------------------------------------------------------------------------*/

tiny City::start ( DBTag party )
{
   short tmpval;
   short tmpval2;
   tiny retval = City_CONTINUE;
   short i;

   p_party.DBselect ( party );

   tiny answer = 0;
   tiny answer2 = 0;

   Menu p_menu_place ( "Places to go" );

   generate_item();

   i = 0;
   while ( i < p_nb_place )
   {
      p_menu_place.add_item ( p_place [ i ].name );
      i++;
   }

   p_menu_place.add_item ( "Edge of Town" );

//   tmpval = p_data.nb_place + 1;
//   tmpval = ( tmpval * 16 ) + 56;

   // menu

   // show graphic
   WinEmpty wem_border;
//   wem_border.preshow();
   
   WinTitle wtl_name ( p_name );
   WinData<Party> wdat_party_bar ( WDatProc_party_bar, p_party,
      WDatProc_POSITION_PARTY_BAR );
//   wtl_name.preshow();


   WinMenu wmnu_place ( p_menu_place, 20, 50, true );
   while ( retval == City_CONTINUE )
   {
      switch ( p_type )
      {
         case City_TYPE_VILLAGE :
            play_music_track ( System_MUSIC_w2city );
         break;
         case City_TYPE_CITY :
            play_music_track ( System_MUSIC_w1tavern );
         break;
         case City_TYPE_CASTLE :
            play_music_track ( System_MUSIC_w1city );
         break;
      }
      wmnu_place.unhide();
      

      Window::instruction ( 320, 340 );

      answer = Window::show_all ();
      
      // make_screen_shot ("cityshot.bmp");

      if ( answer != p_nb_place )
      {
      
         Menu mnu_submenu ( p_place [ answer ] . name );

         i = 0;
         while ( p_place [ answer ] . service [ i ] != -1
            && i < City_NB_MAX_SERVICE )
         {
            mnu_submenu.add_item (
               SERVICE_NAME [ p_place [ answer ] . service [ i ] ] );
            i++;
         }

         mnu_submenu.add_item ( "Exit" );

//         tmpval2 = mnu_submenu.nb_item();
//         tmpval2 = ( tmpval2 * 16 ) + 56 + 24;

         WinMenu wmnu_service ( mnu_submenu, 20, 50 );
         answer2 = 0;
         play_music_track ( p_place [ answer ] . music_track );
         while ( answer2 != -1 )
         {
            wdat_party_bar.refresh();
            Window::instruction ( 320, 340 );
            wmnu_place.hide();
            wmnu_service.unhide();

            answer2 = Window::show_all();

            wmnu_service.hide();
            if ( answer2 == i )
               answer2 = -1;
            
            if ( answer2 != -1 )
               switch ( p_place [ answer ] . service [ answer2 ] )
               {
                  case City_SERVICE_REST :
                     show_service_rest ();
                  break;
                  case City_SERVICE_LEVELUP :
                     show_service_levelup();
                  break;
                  case City_SERVICE_HOME :
                  break;
                  case City_SERVICE_HIRE :
                  break;
//?? add by default return to all menu and treat independently
//                  case City_SERVICE_RETURN :
//                     answer2 = -1;
//                  break;
                  case City_SERVICE_QUIT :
                     retval = City_END_GAME;
                     answer2 = -1;
                  break;
                  case City_SERVICE_BUY :
                     show_service_buy ();
                  break;
                  case City_SERVICE_FORGE :
                  break;
                  case City_SERVICE_ENCHANT :
                  break;
                  case City_SERVICE_IDENTIFY :
                     show_service_identify();
                  break;
                  case City_SERVICE_HEAL :
                     show_service_heal();
                  break;
                  case City_SERVICE_REVIVE :
                     show_service_revive();
                  break;
                  case City_SERVICE_KNOWLEDGE :
                  break;
   /*               case City_SERVICE_LANDWARP :
                  break;
                  case City_SERVICE_SEAWARP :
                  break;
                  case City_SERVICE_AIRWARP :
                  break;
                  case City_SERVICE_MAGIKWARP :
                  break;
                  case City_SERVICE_EXPLORE :
                     p_party.reset_position();

                     retval = City_WARP_TO_MAZE;
                     answer2 = -1;
                  break;*/
                  case City_SERVICE_KEY :
                  break;
                  case City_SERVICE_UNCURSE :
                  break;
                  case City_SERVICE_RETIRE :
                     retval = City_END_GAME;
                     answer2 = -1;
                     p_party.status ( Party_STATUS_RESERVE );
                     p_party.DBupdate();
                  break;
               }
         }
      }
      else
      {
         wtl_name.hide();
         wdat_party_bar.hide();
         play_music_track ( System_MUSIC_w3edge );
         retval = show_edge_of_town ();
         wtl_name.unhide();
         wdat_party_bar.unhide();
         
      }
   }
//   stop_midi ();


   p_party.DBupdate();
   return ( retval );
}

/*void City::generate ( dbs_ADV_City_data dat )
{
 //?? to do convert adventure struct to properties
} */

void City::reference_target ( DBTag citytaglist [ 16 ], DBTag mazetaglist [ 16 ] )
{
   tiny i;
   DBTag tmptag;

   for ( i = 0 ; i < City_NB_MAX_WARP ; i++ )
      p_warp [ i ] . tag . number ( 0 );

   for ( i = 0 ; i < City_NB_MAX_WARP ; i++ )
   {
      if ( p_warp [ i ] . target != - 1 )
      {
         if ( p_warp [ i ] .target < 16 /* not a maze*/ )
         {
            p_warp [ i ].tag = citytaglist [ p_warp [ i ].target ];
         }
         else
            p_warp [ i ].tag = mazetaglist [ p_warp [ i ].target - 16 ];
      }
   }

}


/*-------------------------------------------------------------------------*/
/*-                      Private methods                                  -*/
/*-------------------------------------------------------------------------*/

void City::generate_item ( void )
{
   short i;
   Item tmpitem;
   DBTag tmptag;
   dword index = db.search_table_entry ( DBTABLE_ITEM );
   char tmpstr [ 100 ];

   // random value for eachitem types : Weap, shld, armr, accs, exp, other
   tiny rndval [ 6 ] = { 4, 5, 2, 8, 20, 1 };
   tiny min [ 6 ] = { 2, 3, 1, 4, 5, 1 };
   tiny tmptype;
   
   i = 0;
 //  j = 0;

   // the list of items will regenerate itself at each call.
   // make a sub function to generate
   while ( db.entry_table_tag ( index ) == DBTABLE_ITEM )
   {
      tmpitem.DBselect ( index );
      tmptag = tmpitem.tag();
      if ( ( ( tmpitem.status() & Item_STATUS_FOUND ) == 0  )
         && tmptag.source() != DBSOURCE_SAVEGAME )
      {
         p_item [ i ] . itemtag = tmpitem.tag();
         p_item [ i ] . type = tmpitem.type();
         tmptype = tmpitem.type();
//         p_item [ i ] . quantity = 5;
//         sprintf ( tmpstr, "%s T:%d L:%d", tmpitem.name(),tmpitem.type(),tmpitem.location() );
//         debug ( tmpstr );
         p_item [ i ] . quantity = min [ tmptype ]+rnd( rndval [ tmptype ] );
         i++;
      }
      index++;
   }

/*   copy_buffer ();
   while ( ( readkey() >> 8 ) != KEY_ENTER );*/

   //?? maybe add fine =, Enchanted and some artifact item.

}

void City::show_service_rest ( void )
{
   tiny nb_character = p_party.nb_character();
   Menu mnu_inn ( "What kind of room do you want ?" );
   Menu mnu_days ( "How many days ?" );
   tiny answer;
   tiny answer2;
   tiny i;
   char tmpstr [ 101 ];
   bool have_money;
   tiny price [ 2 ];
   tiny day_multi [ 4 ];
   tiny nb_days;
   Character tmpcharacter;

   day_multi [ 0 ] = 1;
   day_multi [ 1 ] = 3;
   day_multi [ 2 ] = 7;
   day_multi [ 3 ] = 14;
   
   mnu_inn.add_item ( "Common Room  ( 1 Gp / Person / Day )" );
   mnu_inn.add_item ( "Fine Room    ( 3 Gp / Person / Day )" );

   WinData<Party> wdat_gold ( WDatProc_character_gold, p_party,
      WDatProc_POSITION_PARTY_GOLD );
   
   WinMenu wmnu_inn ( mnu_inn, 20, 50 );

   answer = Window::show_all();

   if ( answer != -1 )
   {
      price [ 0 ] = 1;
      price [ 1 ] = 3;

      sprintf ( tmpstr, "1 day : %d Gp", price [ answer ] * day_multi [ 0 ] );
      mnu_days.add_item ( tmpstr );
      
      sprintf ( tmpstr, "3 days : %d Gp", price [ answer ] * day_multi [ 1 ] );
      mnu_days.add_item ( tmpstr );
      
      sprintf ( tmpstr, "1 week : %d Gp", price [ answer ] * day_multi [ 2 ] );
      mnu_days.add_item ( tmpstr );
      
      sprintf ( tmpstr, "2 weeks : %d Gp", price [ answer ] * day_multi [ 3 ] );
      mnu_days.add_item ( tmpstr );

      WinMenu wmnu_days ( mnu_days, 406, 170 );

      answer2 = Window::show_all();

      if ( answer2 != -1 )
      {
         nb_days = day_multi [ answer2 ];
         price [ 0 ] = 1 * nb_days;
         price [ 1 ] = 3 * nb_days;

         have_money = true;
         for ( i = 0 ; i < nb_character ; i++ )
         {
            tmpcharacter.DBselect (p_party.character ( i ) );
            if ( tmpcharacter.gold() < price [ answer ] )
               have_money = false;
         }
      
         if ( have_money == true )
         {
            for ( i = 0 ; i < nb_character ; i++ )
            {
               tmpcharacter.DBselect (p_party.character ( i ) );
               tmpcharacter.lose_gold ( price [ answer ] );
               tmpcharacter.rest ( nb_days, answer );
               tmpcharacter.DBupdate();
            }

         }
         else
         {
            WinMessage wmsg_error ( "Sorry, you cannot afford the room" );
            Window::show_all();
         }
      }
   }
   
   Window::refresh_all();
}

void City::show_service_levelup ( void )
{
   tiny i;
   Character tmpchar;
//   string tmpstr;
   char strmsg [ 241 ];

   for ( i = 0 ; i < p_party.nb_character() ; i++ )
   {
      tmpchar.DBselect ( p_party.character ( i ) );

      if ( tmpchar.check_levelup() == true )
      {
         sprintf ( strmsg, "%s raised a level !", tmpchar.name() );
         WinData<Character> wdat_old ( WDatProc_character_levelup,
            tmpchar, WDatProc_POSITION_LEVELUP_OLD );
         tmpchar.raise_level();
         WinData<Character> wdat_new ( WDatProc_character_levelup,
            tmpchar, WDatProc_POSITION_LEVELUP_NEW );
         WinMessage wmsg_levelup ( strmsg );
         play_sample ( SMP_sound036, 128, 128, 1000, 0 );
         Window::show_all();
         tmpchar.DBupdate();
      }
      else
      {
         int tmpval = static_cast<int>( tmpchar.next_level_exp() - tmpchar.exp() );
         sprintf ( strmsg,"%s Require %d Experience Points\nto reach the next level",
            tmpchar.name(), tmpval );
         WinMessage wmsg_nolevelup ( strmsg );
         Window::show_all();
      }
   }

}

void City::show_service_buy ( void )
{
   Character tmpcharacter;
   tiny answer = 0;
   short answer2 = 0;
   tiny answer3 = 3;
   Menu mnu_equipment ("What do you need ?");
   List lst_item;
   bool mask;
   short i;
   short j;
   short tmpgold;
//   Item *buyitem = NULL;
   byte listID [ City_NB_MAX_ITEM ];
   Item tmpitem;
   Weapon tmpweapon;
   Armor tmparmor;
   Shield tmpshield;
//   string tmpstr;
   char strentry [ 81 ];
//   tiny attribavg;

   mnu_equipment.add_item ("Weapons");
   mnu_equipment.add_item ("Shield");
   mnu_equipment.add_item ("Armor" );
   mnu_equipment.add_item ("Accessories" );
   mnu_equipment.add_item ("Expandables" );
   mnu_equipment.add_item ("Exit" );

   WinData<Party> wdat_gold ( WDatProc_character_gold, p_party,
      WDatProc_POSITION_PARTY_GOLD );

   while ( answer != -1 )
   {
      WinMenu wmnu_equipment ( mnu_equipment, 20, 50 );
  //    Window::draw_all();
//      load_backup_screen ();
//      draw_border_fill ( 14 , 44, 226, 156, General_COLOR_BORDER,
//                                            General_COLOR_FILL );
//      draw_party_bar ( player.selected_party() );
//      answer = mnu_equipment.show ( 20, 50, answer );
      answer = Window::show_all();

      lst_item.clear_all_item();
      lst_item.page_pos ( 0 );
      lst_item.page_size ( 15 );

      tiny type = 0;
//      string titlestr;

      if ( answer == 5 )
         answer = -1;

      if ( answer != -1 )
      {
         type = answer;
         j = 0;
         for ( i = 0 ; i < City_NB_MAX_ITEM ; i++ )
         {
            if ( p_item [ i ].type == type )
            {
               tmpitem.DBselect ( p_item [ i ].itemtag );
               strmake_item_buy ( tmpitem, strentry, p_item [ i ].quantity );
               if ( p_item [ i ].quantity == 0 )
                  mask = true;
               else
                  mask = false;
               lst_item.add_item ( strentry, mask );
               listID [ j ] = i;
               j++;
            }
         }
         lst_item.title ( STR_CTY_BUYTYPE [ type ] );
      }

      WinList wlst_item ( lst_item, 20, 50 );
      answer2 = 0;

      while ( answer2 != -1 && answer != -1 )
      {
         answer2 = Window::show_all();

         if ( answer2 != -1 )
         {
            answer3 = 0;

            while ( answer3 != -1 )
            {
               Menu mnu_character ("Who will take it ?");

               tmpitem.DBselect ( p_item [ listID [ answer2 ] ] . itemtag );

               for ( i = 0 ; i < p_party.nb_character() ; i++ )
               {
                  tmpcharacter.DBselect(p_party.character ( i ) );

                  tmpgold = tmpcharacter.gold ();
                  mask = false;
                  if ( tmpgold < tmpitem.price () ||
                        tmpcharacter.nb_inventory() >= 10 )
                        mask = true;

                  if ( tmpcharacter.is_equipable ( tmpitem.tag() )
                     == true )
                     sprintf ( strentry, " %s", tmpcharacter.name() );
                  else
                     sprintf ( strentry, "#%s", tmpcharacter.name() );
                     
                  // mask characters with not enough gold or too much item
                     mnu_character.add_item ( strentry, mask );
               }

               WinMenu wmnu_character ( mnu_character, 412, 170 );

               answer3 = Window::show_all();
//                  answer3 = mnu_character.show ( 440, 50, answer3 );

               if ( answer3 != -1 )
               {
                  tmpcharacter.DBselect (p_party.character ( answer3 ) );
                  tmpcharacter.new_inventory
                     ( p_item [ listID [ answer2 ] ] . itemtag );
                  tmpcharacter.lose_gold ( tmpitem.price () );
                  tmpcharacter.DBupdate();
                  
                  p_item [ listID [ answer2 ] ] . quantity--;

                  tmparmor.DBselect ( p_item [ listID [ answer2 ] ].itemtag );
                  strmake_armor_buy
                     ( tmparmor, strentry, p_item [ listID [ answer2 ] ].quantity );
                  if ( p_item [ listID [ answer2 ] ].quantity == 0 )
                     mask = true;
                  else
                     mask = false;
                  lst_item.update_item ( strentry, answer2, mask );
                  
                  Window::refresh_all();
                  answer3 = -1;
               }
            }
         }
      }
   }
}

void City::show_service_identify ( void )
{

}

void City::show_service_heal ( void )
{

}

void City::show_service_revive ( void )
{

}

tiny City::show_edge_of_town ( void )
{
   BITMAP* tmpbmp;
   dword index;
   tiny i;
   City tmpcity;
   Maze tmpmaze;
   List lst_target ("Select Destination", 10 );
//   string tmpstr;
   char strmenu [ 51 ];
   tiny answer;
   int color = 0;
   tiny retval;
/*   DBTag citylist [ 16 ];
   dword index;
   tiny i;
   

   index = db.search_table_entry ( DBTABLE_CITY );
   i = 0;
   while ( db.entry_table_tag ( index ) == DBTABLE_CITY )
   {
      city
   }*/
   

   tmpbmp = create_bitmap ( 400, 400 );

   blit ( BMP_aworldmap, tmpbmp, 0, 0, 0, 0, 400, 400 );

   textout_centre ( tmpbmp, FNT_small, p_shortname,
      p_xpos + 12, p_ypos - 16, makecol ( 225, 225, 225 ) );

   i = 0;
   while ( p_warp [ i ] . type != -1 )
   {
      if ( p_warp [ i ] . target < 16 )
      {
         tmpcity.DBselect ( p_warp [ i ].tag );

         switch ( p_warp [ i ] . type )
         {
            case City_WARPTYPE_LAND :
               color = makecol ( 100, 225, 100 );
            break;
            case City_WARPTYPE_SEA :
               color = makecol ( 100, 100, 225 );
            break;
            case City_WARPTYPE_AIR :
               color = makecol ( 225, 225, 225 );
            break;
            case City_WARPTYPE_MAGIC :
               color = makecol ( 225, 100, 100 );
            break;
         }
         sprintf ( strmenu,"%s %s", STR_CTY_WARPACTION [ p_warp [ i ] . type ],
            tmpcity.p_shortname );

         lst_target.add_item ( strmenu );
         line ( tmpbmp, p_xpos + 8, p_ypos + 8,
            tmpcity.xpos() + 8, tmpcity.ypos() + 8, color );
         textout_centre ( tmpbmp, FNT_small, tmpcity.p_shortname,
         tmpcity.xpos() + 12, tmpcity.ypos() - 16, makecol ( 225, 225, 225 ) );
         
      }
      else
      {
         tmpmaze.DBselect ( p_warp [ i ] . tag );
         sprintf ( strmenu, "Explore %s",tmpmaze.shortname() );
         lst_target.add_item ( strmenu );
         line ( tmpbmp, p_xpos + 8, p_ypos + 8,
            tmpmaze .xpos() + 8, tmpmaze.ypos() + 8, General_COLOR_TEXT );
         textout_centre ( tmpbmp, FNT_small, tmpmaze.shortname(),
         tmpmaze.xpos() + 12, tmpmaze.ypos() - 16, makecol ( 225, 225, 225 ) );

         switch ( tmpmaze.type() )
         {
            case Maze_TYPE_CAVE :
               draw_sprite ( tmpbmp, BMP_icn_cave, tmpmaze.xpos(), tmpmaze.ypos() );
            break;
            case Maze_TYPE_KEEP :
               draw_sprite ( tmpbmp, BMP_icn_keep, tmpmaze.xpos(), tmpmaze.ypos() );
            break;
            case Maze_TYPE_RUIN :
               draw_sprite ( tmpbmp, BMP_icn_ruin, tmpmaze.xpos(), tmpmaze.ypos() );
            break;
            case Maze_TYPE_TEMPLE :
               draw_sprite ( tmpbmp, BMP_icn_temple, tmpmaze.xpos(), tmpmaze.ypos() );
            break;
            case Maze_TYPE_TOWER :
               draw_sprite ( tmpbmp, BMP_icn_tower, tmpmaze.xpos(), tmpmaze.ypos() );
            break;
         }
      }
      i++;
   }

   index = db.search_table_entry ( DBTABLE_CITY );
   while ( db.entry_table_tag ( index ) == DBTABLE_CITY )
   {
      tmpcity.DBselect ( index );
      switch ( tmpcity.type() )
      {
         case City_TYPE_VILLAGE :
            draw_sprite ( tmpbmp, BMP_icn_village, tmpcity.xpos(), tmpcity.ypos() );
         break;
         case City_TYPE_CITY :
            draw_sprite ( tmpbmp, BMP_icn_city, tmpcity.xpos(), tmpcity.ypos() );
         break;
         case City_TYPE_CASTLE :
            draw_sprite ( tmpbmp, BMP_icn_castle, tmpcity.xpos(), tmpcity.ypos() );
         break;
      }
      index++;
   }
   

   lst_target.add_item ("Cancel");

/*   tiny type a_packed;
//   short distance a_packed;
   tiny target a_packed;
   DBTag tag a_packed;
*/

   WinData<BITMAP> wdat_worldmap ( WDatProc_worldmap, *tmpbmp,
      WDatProc_POSITION_WORLDMAP );

   WinList wlst_target ( lst_target, 420, 30 );
   Window::instruction ( 320, 460 );

   answer = Window::show_all();
//   make_screen_shot ( "mapshot.bmp");//@@
   retval = City_CONTINUE;

   if ( answer != -1 && answer != i )
   {
      if ( p_warp [ answer ] . target >= 16 )
      {
         p_party.reset_position();
         p_party.location ( p_warp [ answer ] . tag );
         p_party.status ( Party_STATUS_MAZE );
//         p_party.DBupdate();
         retval = City_WARP_TO_MAZE; // indicate the party has just warped
         // select maze
      }
      else
      {
         p_party.location ( p_warp [ answer ] . tag );
         p_party.status ( Party_STATUS_CITY );
//         p_party.DBupdate();
         retval = City_WARP_TO_CITY;
      }
   }

   destroy_bitmap ( tmpbmp );

   return ( retval );
}

void City::objdat_to_strdat ( void *dataptr )
{
   dbs_City &tmpdat = *(static_cast<dbs_City*> ( dataptr ));
   tiny i;
   tiny j;
   
   strncpy ( tmpdat.name, p_name, 31 );
   strncpy ( tmpdat.shortname, p_shortname, 11 );
   tmpdat.nb_place = p_nb_place;
   tmpdat.xpos = p_xpos;
   tmpdat.ypos = p_ypos;
   tmpdat.type = p_type;

   for ( i = 0 ; i < City_NB_MAX_LOCATION ; i++ )
   {
      strncpy ( tmpdat.place [ i ].name, p_place [ i ].name, 21 );
      tmpdat.place [ i ].music_track = p_place [ i ].music_track;

      for ( j = 0 ; j < City_NB_MAX_SERVICE ; j++ )
         tmpdat.place [ i ].service [ j ] = p_place [ i ].service [ j ];
   }

   for ( i = 0 ; i < City_NB_MAX_WARP ; i++ )
   {
      tmpdat.warp [ i ].type = p_warp [ i ].type;
      tmpdat.warp [ i ].target = p_warp [ i ].target;
      tmpdat.warp [ i ].tag = p_warp [ i ].tag;
   }
}

void City::strdat_to_objdat ( void *dataptr )
{
   dbs_City &tmpdat = *(static_cast<dbs_City*> ( dataptr ));
   tiny i;
   tiny j;
   
   strcpy ( p_name, tmpdat.name );
   strcpy ( p_shortname, tmpdat.shortname );
   p_nb_place = tmpdat.nb_place;
   p_xpos = tmpdat.xpos;
   p_ypos = tmpdat.ypos;
   p_type = tmpdat.type;

   for ( i = 0 ; i < City_NB_MAX_LOCATION ; i++ )
   {
      strcpy ( p_place [ i ].name, tmpdat.place [ i ].name );
      p_place [ i ].music_track = tmpdat.place [ i ].music_track;

      for ( j = 0 ; j < City_NB_MAX_SERVICE ; j++ )
         p_place [ i ].service [ j ] = tmpdat.place [ i ].service [ j ];
   }

   for ( i = 0 ; i < City_NB_MAX_WARP ; i++ )
   {
      p_warp [ i ].type = tmpdat.warp [ i ].type;
      p_warp [ i ].target = tmpdat.warp [ i ].target;
      p_warp [ i ].tag = tmpdat.warp [ i ].tag;
   }

}

void City::child_DBremove ( void )
{
// this function does nothing
}

void City::alternate_strdat_to_objdat ( tiny datatypeID, void *dataptr )
{
   //note : only 1 alternate loading so datatype is not considered

   dbs_ADV_City_data &tmpdat = *(static_cast<dbs_ADV_City_data*> ( dataptr ));
   tiny i;
   tiny j;
   tiny placeindex [ City_NB_MAX_LOCATION ];
   tiny tmpindex;

   strcpy ( p_name, tmpdat.name );
   strcpy ( p_shortname, tmpdat.shortname );
   p_nb_place = tmpdat.nb_place;
   p_xpos = tmpdat.xpos;
   p_ypos = tmpdat.ypos;
   p_type = tmpdat.type;

   for ( i = 0 ; i < City_NB_MAX_LOCATION ; i++ )
   {
      strcpy ( p_place [ i ].name, tmpdat.place [ i ].name );
      p_place [ i ].music_track = tmpdat.place [ i ].music_track;
   }
   
   for ( i = 0 ; i < City_NB_MAX_WARP ; i++ )
   {
      p_warp [ i ].type = tmpdat.warp [ i ].type;
      p_warp [ i ].target = tmpdat.warp [ i ].target;
//      p_warp [ i ].tag = tmpdat.warp [ i ].tag;
   }

   for ( i = 0 ; i < City_NB_MAX_LOCATION ; i++ )
      placeindex [ i ] = 0;

   for ( i = 0 ; i < City_NB_MAX_LOCATION ; i++ )
      for ( j = 0 ; j < City_NB_MAX_SERVICE ; j++ )
         p_place [ i ].service [ j ] = -1;
   
   for ( i = 0 ; i < City_NB_SERVICE ; i++ )
   {
      tmpindex = tmpdat.service_location [ i ];
      if ( tmpindex != -1 )
      {
         p_place [ tmpindex ].service [ placeindex [ tmpindex ] ] = i;
         placeindex [ tmpindex ]++;
      }
   }
   
}



