/***************************************************************************/
/*                                                                         */
/*                          C H A R A C T R . C P P                        */
/*                                                                         */
/*                            Class source code                            */
/*                                                                         */
/*     Content : Class Character source code                               */
/*     Programmer : Eric Pietrocupo                                        */
/*     Starting Date : April 26, 2002                                      */
/*                                                                         */
/***************************************************************************/

#include <allegro.h>
#include <general.h>

#include <stdio.h>   // to comment
#include <math.h>
//#include <stdlib.h>
//#include <time.h>

#include <string.h>
//#include <datafile.h>
//#include <datmacro.h>
#include <system.h>
//#include <init.h>
//#include <menu.h>
//#include <option.h>
//#include <screen.h>
//#include <dbdata.h>
//#include <dbtag.h>
//#include <database.h>
//#include <dbobject.h>
#include <ddt.h>
#include <dbdef.h>
#include <item.h>
#include <armor.h>
#include <weapon.h>
#include <shield.h>
#include <accesory.h>
#include <expandbl.h>
//#include <list.h>
#include <race.h>
#include <cclass.h>
#include <opponent.h>
#include <charactr.h>
#include <ennemy.h>
//#include <party.h>
//#include <player.h>
#include <game.h>
//#include <city.h>
//#include <maze.h>
//#include <adventur.h>
//#include <camp.h>
//#include <config.h>
//#include <draw.h>
//#include <dialog.h>
//#include <combat.h>
//#include <window.h>   // to comment
//#include <winmessa.h> // to comment

tiny Character::p_levelup_speed = Game_LEVELUP_NORMAL;

/*-------------------------------------------------------------------------*/
/*-                       Constructor and destructor                      -*/
/*-------------------------------------------------------------------------*/

Character::Character ( void )
{
   clean ();

   p_dblength = sizeof ( dbs_Character );
   p_dbtableID = DBTABLE_CHARACTER;
   p_type = Opponent_TYPE_CHARACTER;
}


Character::~Character ( void )
{

}

/*-------------------------------------------------------------------------*/
/*-                       Property Method                                 -*/
/*-------------------------------------------------------------------------*/


const char* Character::family ( void )
{
   return ( p_family );
}

void Character::family ( const char *str )
{
   strncpy ( p_family, str, 16 );
}


const char* Character::reputation ( void )
{
   return ( p_reputation );
}

void Character::reputation ( const char *str )
{
   strncpy ( p_reputation, str, 16 );
}

void Character::rank ( tiny rankID )
{
   p_rank = rankID;
}

tiny Character::rank ( void )
{
   return ( p_rank );
}

void Character::institution ( tiny institutionID )
{
   p_institution = institutionID;
}

tiny Character::institution ( void )
{
   return ( p_institution );
}


void Character::race ( DBTag value )
{
   p_race = value;
}

DBTag Character::race ( void )
{
   return ( p_race );
}

void Character::cclass ( DBTag value )
{
   p_cclass = value;
}

DBTag Character::cclass ( void )
{
   return ( p_cclass );
}


void Character::sex ( tiny value )
{
   p_sex = value;
}

tiny Character::sex ( void )
{
   return ( p_sex );
}

float Character::age ( void )
{
   return ( static_cast <float>(p_age) );
}

void Character::age ( float value )
{
   p_age = static_cast<fix>(value);
}

int Character::exp ( void )
{
   return ( p_experience );
}

tiny Character::available ( void )
{
   return ( p_available );
}

void Character::available ( tiny value )
{
   p_available = value;
}



int Character::encumbrance ( void )
{
   return ( p_encumbrance );
}

float Character::weight ( void )
{
   return ( p_weight );
}

short Character::maxweight ( void )
{
   short tmpvalue;
   tmpvalue = ( p_attribute [ Character_STRENGTH ] +
               p_attribute [ Character_ENDURANCE ] ) * 3;


   switch ( p_size )
   {
      case Opponent_SIZE_TINY :
         tmpvalue = tmpvalue - ( tmpvalue / 2 );
      break;
      case Opponent_SIZE_SHORT :
         tmpvalue = tmpvalue - ( tmpvalue / 4 );
      break;
      case Opponent_SIZE_LARGE :
         tmpvalue = tmpvalue + ( tmpvalue / 4 );
      break;
      case Opponent_SIZE_HUGE :
         tmpvalue = tmpvalue + ( tmpvalue / 2 );
      break;
      
   }
               
   if ( tmpvalue == 0 )
      tmpvalue = 1;

   return ( tmpvalue );
      
}

const char* Character::combatstr ( void )
{
   return ( p_combatstr );
}

void Character::combatstr ( const char *str )
{
   strncpy ( p_combatstr, str, 13 );
//   p_combatstr [ 13 ] = '\0';
}


void Character::levelup_speed ( byte value )
{
   p_levelup_speed = value;

/*   switch ( value )
   {
      case Game_LEVELUP_FAST :
         p_levelup_exponent = 1.5;
      break;
      case Game_LEVELUP_NORMAL :
         p_levelup_exponent = 1.75;
      break;
      case Game_LEVELUP_SLOW :
         p_levelup_exponent = 2;
      break;
   }*/
}

/*------------------------ Equipment Methods ------------------------------*/

DBTag Character::inventory ( tiny index )
{
  return ( p_inventory [ index ] );
}

DBTag Character::equiped ( tiny index )
{
   return ( p_equiped [ index ] );
}
/*
DBTag Character::weapon ( void )
{
   return ( p_weapon );
}

DBTag Character::shield ( void )
{
   return ( p_shield);
}


DBTag Character::armor ( void )
{
   return ( p_armor);
}


DBTag Character::feet ( void )
{
   return ( p_feet);
}


DBTag Character::hand ( void )
{
   return ( p_hand);
}


DBTag Character::head ( void )
{
   return ( p_head );
}


DBTag Character::other ( void )
{
   return ( p_other );
} */


tiny Character::new_inventory ( DBTag itemtag )
{
   tiny invent_size;
   DBTag tmptag;

   invent_size = p_nb_inventory;

   if ( invent_size < Character_INVENTORY_SIZE )
   {
      tmptag = db.copy ( itemtag, DBSOURCE_SAVEGAME );
      p_inventory [ invent_size ] = tmptag;
      p_nb_inventory++;
      eval_stat_all();
   }
   else
      return ( Character_ITEM_INVENTORY_FULL );
}

tiny Character::delete_inventory ( tiny inventoryID )
{
   tiny i;

   if ( p_nb_inventory > 0 )
   {
      db.remove ( p_inventory [ inventoryID ] );
      p_inventory [ inventoryID ] .number ( 0 );

      for ( i = inventoryID; i < Character_INVENTORY_SIZE - 1; i++ )
         p_inventory [ i ] = p_inventory [ i + 1 ];

      p_inventory [ Character_INVENTORY_SIZE - 1 ] . number( 0 );
      eval_stat_all();
      p_nb_inventory--;
   }
   return ( Character_ITEM_SUCCESSFULL );   
}

tiny Character::remove_inventory ( tiny inventoryID )
{
   tiny i;

//   delete p_inventory [ inventoryID ];
   p_inventory [ inventoryID ] .number ( 0 );

   for ( i = inventoryID; i < Character_INVENTORY_SIZE - 1; i++ )
      p_inventory [ i ] = p_inventory [ i + 1 ];

   p_inventory [ Character_INVENTORY_SIZE - 1 ] . number( 0 );
   eval_stat_all();
   p_nb_inventory--;

   return ( Character_ITEM_SUCCESSFULL );
}
tiny Character::add_inventory ( DBTag itemtag )
{
   tiny invent_size;

   invent_size = nb_inventory ();

   if ( invent_size < Character_INVENTORY_SIZE - 1 )
   {
      p_inventory [ invent_size ] = itemtag;
      eval_stat_all();
      p_nb_inventory++;
//      allocate_new_item ( invent_size, obj );
   }
   else
      return ( Character_ITEM_INVENTORY_FULL );
}

tiny Character::equip_item ( tiny inventoryID )
{
//   tiny item_type;
   tiny accessory_location;
   Item tmpitem;
   Accessory tmpacc;
   Weapon tmpwpn;
   tiny error = Character_ITEM_SUCCESSFULL;

   if ( p_inventory [ inventoryID ] != 0 )
   {
      tmpitem.DBselect ( p_inventory [ inventoryID ] );

      if ( is_equipable ( tmpitem.tag() ) == false )
         return ( Character_ITEM_CLASS_RESTRICTION );

//?? Need to check for 2 hand weapon and shield
/*               tmpwpn.DBselect ( p_inventory [ inventoryID ] );

               if ( tmpwpn.nb_hand() == Weapon_TWOHANDED &&
                  p_shield != 0 )
                  error = Character_ITEM_TWOHAND_NOSHIELD;
               else*/
       if ( tmpitem.location() != Item_LOCATION_NOLOC )
       {
          if ( p_equiped [ tmpitem.location() ] == 0 )
             p_equiped [ tmpitem.location() ]  = p_inventory [ inventoryID ];
          else
             error = Character_ITEM_ALREADY_EQUIPED;
       }
       else
          error = Character_ITEM_UNEQUIPABLE;
   }
   

/*      switch ( tmpitem.type() )
      {
         case Item_TYPE_WEAPON :
            if ( p_weapon == 0 )
            {
                  p_weapon = p_inventory [ inventoryID ];
            }
            else
               error = Character_ITEM_ALREADY_EQUIPED;

         break;

         case Item_TYPE_SHIELD :
            if ( p_shield == 0 )
            {
                  p_shield = p_inventory [ inventoryID ];
            }
            else
               error = Character_ITEM_ALREADY_EQUIPED;
         break;

         case Item_TYPE_ARMOR :
            if ( p_armor == 0 )
               p_armor = p_inventory [ inventoryID ];
            else
               error = Character_ITEM_ALREADY_EQUIPED;
         break;

         case Item_TYPE_ACCESSORY :
            tmpacc.DBselect ( p_inventory [ inventoryID ] );
            accessory_location = tmpacc.location();
            switch ( accessory_location )
            {
               case Accessory_LOCATION_HEAD  :
                  if ( p_head == 0 )
                     p_head = p_inventory [ inventoryID ];
                  else
                     error = Character_ITEM_ALREADY_EQUIPED;
               break;

               case Accessory_LOCATION_FEET  :
                  if ( p_feet == 0 )
                     p_feet = p_inventory [ inventoryID];
                  else
                     error = Character_ITEM_ALREADY_EQUIPED;
               break;

               case Accessory_LOCATION_HAND  :
                  if ( p_hand == 0 )
                     p_hand = p_inventory [ inventoryID];
                  else
                     error = Character_ITEM_ALREADY_EQUIPED;
               break;

               case Accessory_LOCATION_OTHER :
                  if ( p_other == 0 )
                     p_other = p_inventory [ inventoryID];
                  else
                     error = Character_ITEM_ALREADY_EQUIPED;
               break;
            }
         break;

         default :
            error = Character_ITEM_UNEQUIPABLE;
         break;
      }
   }*/

   if ( error == Character_ITEM_SUCCESSFULL )
   {
      eval_stat_all();
      remove_inventory ( inventoryID );
      p_nb_equiped++;

   }
   return ( error );
}

tiny Character::unequip_item ( tiny location )
{
   Item tmpitem;

   if ( p_equiped [ location ] != 0 )
   {
      tmpitem.DBselect ( p_equiped [ location ] );
      
      if ( tmpitem.cursed () == true )
         return ( Character_ITEM_CURSED );

      if ( nb_inventory () < Character_INVENTORY_SIZE )
      {
          add_inventory ( p_equiped [ location ] );
          p_equiped [ location ].number ( 0 );
          p_nb_equiped--;
      }
      else
         return (Character_ITEM_INVENTORY_FULL);
      
   }
   else
      return (Character_ITEM_ALREADY_UNEQUIPED );

/*   switch ( location )
   {
      case Character_UNEQUIP_WEAPON :
         if ( p_weapon != 0)
            tmpitem.DBselect ( p_weapon );
      break;

      case Character_UNEQUIP_SHIELD :
         if ( p_shield != 0)
            tmpitem.DBselect ( p_shield );
      break;

      case Character_UNEQUIP_ARMOR :
         if ( p_armor != 0)
            tmpitem.DBselect ( p_armor );
      break;

      case Character_UNEQUIP_HEAD :
         if ( p_head != 0)
            tmpitem.DBselect ( p_head );
      break;

      case Character_UNEQUIP_HAND :
         if ( p_hand != 0)
            tmpitem.DBselect ( p_hand );
      break;

      case Character_UNEQUIP_FEET :
         if ( p_feet != 0)
            tmpitem.DBselect ( p_feet );
      break;

      case Character_UNEQUIP_OTHER :
         if ( p_other != 0)
            tmpitem.DBselect ( p_other );
      break;
   }*/



/*   if ( nb_inventory () < Character_INVENTORY_SIZE )
   {
      switch ( location )
      {
         case Character_UNEQUIP_WEAPON :

            if ( p_weapon != 0)
            {
               add_inventory ( p_weapon );
               p_weapon.number ( 0 );
               p_nb_equiped--;
            }
         break;

      
         case Character_UNEQUIP_SHIELD :
            if ( p_shield != 0)
            {
               add_inventory ( p_shield );
               p_shield.number ( 0 );
               p_nb_equiped--;               
            }
         break;
      
         case Character_UNEQUIP_ARMOR :
            if ( p_armor != 0)
            {
               add_inventory ( p_armor );
               p_armor.number ( 0 );
               p_nb_equiped--;               
            }
         break;
      
         case Character_UNEQUIP_HEAD :
            if ( p_head != 0)
            {
               add_inventory ( p_head );
               p_head.number ( 0 );
               p_nb_equiped--;               
            }
         break;
      
         case Character_UNEQUIP_HAND :
            if ( p_hand != 0)
            {
               add_inventory ( p_hand );
               p_hand.number ( 0 );
               p_nb_equiped--;               
            }
         break;
      
         case Character_UNEQUIP_FEET :
            if ( p_feet != 0)
            {
               add_inventory ( p_feet );
               p_feet.number ( 0 );
               p_nb_equiped--;               
            }
         break;
      
         case Character_UNEQUIP_OTHER :
            if ( p_other != 0)
            {
               add_inventory ( p_other );
               p_other.number ( 0 );
               p_nb_equiped--;               
            }
         break;
      }
   }*/
/*   else
      return (Character_ITEM_INVENTORY_FULL);*/

   return ( Character_ITEM_SUCCESSFULL );
}

tiny Character::nb_inventory ( void )
{

   return ( p_nb_inventory );
}

tiny Character::nb_equiped ( void )
{
   return ( p_nb_equiped );
}

bool Character::is_equipable ( DBTag itemtag )
{
   bool retval = true; // expandables and Accessories have no restriction
   Item tmpitem;
   Weapon tmpweapon;
   Armor tmparmor;
   Shield tmpshield;
   CClass tmpclass;
   byte mask;

   tmpitem.DBselect ( itemtag );
   tmpclass.DBselect ( p_cclass );
   switch ( tmpitem.type() )
   {
      case Item_TYPE_WEAPON :
         tmpweapon.DBselect ( itemtag );

/*         mask = 1 << tmpweapon.range();
         if ( ( tmpclass.wprof_range() & mask ) == 0 )
            retval = false;

         mask = 1 << tmpweapon.attribute();
         if ( ( tmpclass.wprof_attrib() & mask ) == 0 )
            retval = false;

         mask = tmpweapon.nb_hand();
         if ( ( tmpclass.wprof_nb_hand() & mask ) == 0 )
            retval = false;*/

         if ( ( tmpweapon.category() & tmpclass.weapon_profiency() ) == 0 )
            retval = false;
      break;
      case Item_TYPE_ARMOR :
         tmparmor.DBselect ( itemtag );
         if ( tmparmor.category() > tmpclass.armor_profiency() )
            retval = false;
      break;
      case Item_TYPE_SHIELD :
         tmpshield.DBselect ( itemtag );
         if ( tmpshield.category() > tmpclass.shield_profiency() )
            retval = false;
      break;
   }

   //?? maybe add size restriction

   return ( retval );

}

/*----------------- Data to string interpretation -------------------------*/


const char* Character::sexC ( void )
{
   return ( STR_CHR_SEXC [ p_sex ] );
}


const char* Character::sexS ( void )
{
   return ( STR_CHR_SEX [ p_sex ] );
}

void Character::raceS ( char *str )
{
   Race tmprace;
   
   if ( p_race.number() != 0 )
   {
      tmprace.DBselect ( p_race );
      strcpy ( str, tmprace.name() );
   }
   else
      strcpy ( str, "" );


}

void Character::cclassS ( char* str )
{
   CClass tmpcclass;
   
   if ( p_cclass.number() != 0 )
   {
      tmpcclass.DBselect ( p_cclass );
      strcpy ( str, tmpcclass.name() );
   }
   else
      strcpy ( str, "" );

};



const char* Character::availableS ( void )
{
   return ( STR_CHR_AVAILABLE [ p_available ] );
}

/*-------------------------------------------------------------------------*/
/*-                           Methods                                     -*/
/*-------------------------------------------------------------------------*/

void Character::clean ( void )
{
   tiny i;
   tiny j;

   strcpy ( p_name,"");
   strcpy ( p_family, "");
   strcpy ( p_reputation, "");
   p_rank = -1;
   p_institution = -1;

   for ( i = 0 ; i < 7 ; i++ )
      p_attribute [ i ] = 0;

   p_race.number ( 0 );
   p_aligment = -1;
   p_sex = -1;
   p_level = 0;
   p_age = 0;
   p_experience = 0;
   p_max_HP = 0;
   p_current_HP = 0;
   p_max_MP = 0;
   p_current_MP = 0;
   p_soul = 0;
   p_health = 0;
   p_status = -1;
   p_available = -1;
   p_gold = 0;

   strcpy ( p_combatstr, "" );
//   combatstr ("Allo");

   for ( i = 0 ; i < Character_INVENTORY_SIZE ; i++ )
      p_inventory [ i ].number ( 0 );

   for ( i = 0 ; i < Character_EQUIP_SIZE ; i++ )
      p_equiped [ i ].number ( 0 );


/*   p_weapon.number ( 0 );
   p_armor.number ( 0 );
   p_shield.number ( 0 );
   p_head.number ( 0 );
   p_hand.number ( 0 );
   p_feet.number ( 0 );
   p_other.number ( 0 );*/

   p_weight = 0;
   p_encumbrance = 0;

}

void Character::create_new_stats ( void )
{
   tiny i;
   Race tmprace;   
   float ageperc;
   float tmpage;
   byte tmpval;
   tmprace.DBselect ( p_race );   

   p_level = 1;
   p_experience = 0;
   p_max_HP = tmprace.HPdice() + hdice ( tmprace.HPdice() ) + 1 + ENDmodifier();
   p_current_HP = p_max_HP;
   p_max_MP = tmprace.MPdice() + hdice ( tmprace.MPdice() ) + 1 + WILmodifier();
   p_current_MP = p_max_MP;
   p_soul = 100;
   p_health = 0;
   p_status = Opponent_STATUS_ALIVE;
   p_available = Character_AVAILABLE;

   p_gold = ( 200 + ( rnd ( 12 ) * 25 ) ) /* * 50  tmp multiplier */;
   ageperc = 19 + rnd(11);
   tmpage = ( ageperc / 100 ) * tmprace.lifespan();
   p_age = static_cast <short> (tmpage);

   p_size = tmprace.size();

   p_current_HP = p_max_HP;
   p_current_MP = p_max_MP;

   p_nb_inventory = 0;
   p_nb_equiped = 0;

   for ( i = 0 ; i < Character_INVENTORY_SIZE ; i++ )
      p_inventory [ i ] = 0;

   for ( i = 0 ; i < Character_EQUIP_SIZE ; i++ )
      p_equiped [ i ] = 0;



}

void Character::init_race_attribute ( void )
{
   tiny i;
   Race tmprace;

   tmprace.DBselect ( p_race );

   for ( i = 0 ; i < 6 ; i++ )
      p_attribute [ i ] = tmprace.attribute ( i );

   // set sex attributes

   if ( p_sex == Character_FEMALE )
      p_attribute [ Opponent_CUNNING ]++;
   else
      p_attribute [ Opponent_STRENGTH ]++;

   p_attribute [ Opponent_LUCK ] = rnd (11) + 4;
}

void Character::autoability ( void )
{
//?? not sure if set like magik effect
}

dword Character::use_ability ( tiny inventoryID )
{
   return ( 0 );
}



bool Character::check_levelup ( void )
{
   if ( p_level < 50 ) // maximum level is 50
   {
      if ( p_experience >= /*( ( pow ( p_level, p_levelup_exponent ) * 100 ) )*/
         EXP_TABLE [ p_level ] [ p_levelup_speed ]  )
         return ( true );
      else
         return ( false );
   }
   return ( false );
}

int Character::next_level_exp ( void )
{
   return ( EXP_TABLE [ p_level ] [ p_levelup_speed ] /*static_cast <dword>
      ( ( pow ( p_level, p_levelup_exponent ) * 100 ) )*/ );
}


void Character::raise_level ( void )
{
   tiny i;
//   tiny attribsum;
//   tiny attribavg;
   tiny roll;
   tiny hppenalty = 0;
   tiny mppenalty = 0;
   tiny tmpval;
   Race tmprace;
   CClass tmpclass;

   tmprace.DBselect ( p_race );
   tmpclass.DBselect ( p_cclass );

   hppenalty = ( p_level / tmpclass.HPdiv() );
   mppenalty = ( p_level / tmpclass.MPdiv() );

   // raise soul by 2 points

   recover_soul ( 2 );

   // raise level
   p_level++;

   // raise HP
   tmpval = hdice ( tmprace.HPdice() ) + ENDmodifier() - hppenalty;
   if ( tmpval < 2 )
      tmpval = 2;
   p_max_HP = p_max_HP + tmpval;
   p_current_HP = p_current_HP + tmpval;

   // raise MP
   tmpval = hdice ( tmprace.MPdice() ) + WILmodifier() - mppenalty;
   if ( tmpval < 2 )
      tmpval = 2;
   p_max_MP = p_max_MP + tmpval;
   p_current_MP = p_current_MP + tmpval;

}

void Character::gain_exp ( int value )
{
   p_experience = p_experience + value;
   if ( p_experience > 2000000000L )
      p_experience = 2000000000L;
}


void Character::lose_exp ( int value )
{
   p_experience = p_experience - value;
   if ( p_experience < 0 )
      p_experience = 0;

}


void Character::rest ( tiny nb_days, tiny room_type )
{
   tiny i;
   tiny j;
   tiny k;
   tiny levelmod;
   Race tmprace;

   tmprace.DBselect ( p_race );

   levelmod = ( p_level / 5 );

   tiny tmpval;
   bool allocated;

   short recHP = 0;
   short recMP = 0;

   switch ( room_type )
   {
      case 0 /*City_ROOMTYPE_COMMON */ :
         recHP = tmprace.HPdice() + ENDmodifier() + levelmod;
         if ( recHP < 4 )
            recHP = 4;
         recMP = tmprace.MPdice() + WILmodifier() + levelmod;
         if ( recMP < 4 )
            recMP = 4;
      break;
      case 1 /*City_ROOMTYPE_FINE*/ :
         recHP = tmprace.HPdice() + ENDmodifier() + levelmod;
         if ( recHP < 4 )
            recHP = 4;
         recHP += ( recHP / 2 );
         recMP = tmprace.MPdice() + WILmodifier() + levelmod;
         if ( recMP < 4 )
            recMP = 4;
         recMP += ( recMP / 2 );
      break;
   }

   for ( i = 0 ; i < nb_days ; i++ )
   {
      recover_HP ( hdice ( recHP ) );
      recover_MP ( hdice ( recMP ) );
   }
   raise_days ( nb_days );
}

void Character::raise_days ( tiny nb_days )
{
   p_age = p_age + ( 0.001 * nb_days );

   int tmpage = static_cast<int>(p_age);
   float restage = p_age - tmpage;
   
   if ( restage > 0.320 )
   {
      tmpage = tmpage + 1;
      p_age = tmpage;
      recover_soul ( dice ( 5 ) );
      
      //?? todo : add aging effect
   }
   
}

void Character::eval_stat_race ( void )
{
   tiny i;
   tiny j;
   Race tmprace;

   if ( p_race != 0 )
   {
      tmprace.DBselect ( p_race );

      p_stat.dmg_y += tmprace.DMGdice();
      p_stat.mdmg_y += tmprace.MDMGdice();

      p_stat.hlt_resist = ( p_stat.hlt_resist | tmprace.health_resist() );

      // ability bonus

      for ( i = 0 ; i < 3 ; i++ )
      {
         switch ( tmprace.ability ( i ) )
         {
            case Race_ABILITY_FLYING :
               p_stat.AD += 1;
               p_stat.init += 1;
            break;
            case Race_ABILITY_ARMOR_SKIN :
               p_stat.PD += 3;
               p_stat.DR += 2;
            break;
            case Race_ABILITY_RESIST_MAGIC :
               p_stat.MPD += 3;
               p_stat.MDR += 2;
            break;
            case Race_ABILITY_LUCKY :
               p_stat.PSAVE += 3;// maybe OK
               p_stat.MSAVE += 3; // maybe OK
            break;
         }
      }
   }
}
void Character::eval_stat_class ( void )
{
   CClass tmpclass;

   if ( p_cclass != 0 )
   {
      tmpclass.DBselect ( p_cclass );
      p_stat.elm_resist = ( p_stat.elm_resist | tmpclass.elm_resist () );
      p_stat.elm_effect = ( p_stat.elm_effect | tmpclass.elm_effect () );
      p_stat.hlt_effect = ( p_stat.hlt_effect | tmpclass.hlt_effect () );
      p_stat.hlt_resist = ( p_stat.hlt_resist | tmpclass.hlt_resist() );
      p_stat.magikproperty = ( p_stat.magikproperty & tmpclass.magikproperty () );
      p_stat.dmg_y += ( p_level / tmpclass.DMGdiv () );
      p_stat.mdmg_y += ( p_level / tmpclass.MDMGdiv () );
      p_stat.multihitmod += 16 - ( p_level / tmpclass.mulhitdiv () );
      p_stat.AD += tmpclass.baseAD ();
      p_stat.MAD += tmpclass.baseMAD ();

      if ( tmpclass.baseMAD() > 0 )
         p_stat.MAD += CUNmodifier();


      // skill influence ???
   }
}

void Character::eval_stat_equipment ( void )
{
   tiny i;
   tiny j;
   word mask;
   Item tmpitem;
   Armor tmparmor;
   Weapon tmpweapon;
   Shield tmpshield;
   Accessory tmpaccessory;
   CClass tmpclass;

   // compile Health , Elemental resist and effect

   for ( i = Character_EQUIP_SHIELD ; i < Character_EQUIP_SIZE ; i++ )
   {
      if ( p_equiped [ i ] != 0 )
      {
         tmpitem.DBselect ( p_equiped [ i ] );
         p_stat.elm_resist = ( p_stat.elm_resist & tmpitem.elmeffect() );
         p_stat.hlt_resist = ( p_stat.hlt_resist & tmpitem.hlteffect() );
         p_stat.magikproperty = ( p_stat.magikproperty & tmpitem.magikproperty() );
      }
   }

   // Armor

   if ( p_equiped [ ARMOR ] != 0 )
   {
      tmparmor.DBselect ( p_equiped [ ARMOR ] );
      p_stat.PD = p_stat.PD + tmparmor.PD();
      p_stat.AD = p_stat.AD + tmparmor.AD();
      p_stat.DR = p_stat.DR + tmparmor.DR();
      p_stat.MPD = p_stat.MPD + tmparmor.MPD();
      p_stat.MDR = p_stat.MDR + tmparmor.MDR();
   }

   if ( p_equiped [ SHIELD ] != 0 )
   {
      tmpshield.DBselect ( p_equiped [ SHIELD ] );
      p_stat.PD = p_stat.PD + tmpshield.PD();
      p_stat.AD = p_stat.AD + tmpshield.AD();
      p_stat.MPD = p_stat.MPD + tmpshield.MPD();
      p_stat.MAD = p_stat.MAD + tmpshield.MAD();
   }

   if ( p_equiped [ WEAPON ] != 0 )
   {
      tmpweapon.DBselect ( p_equiped [ WEAPON ] );
      p_stat.dmg_x = p_stat.dmg_x + tmpweapon.dmg_x();
      p_stat.dmg_z = p_stat.dmg_z + tmpweapon.dmg_z();
      p_stat.dmg_type = tmpweapon.dmg_type();
//      p_stat.size = tmpweapon.size();
      p_stat.range = tmpweapon.range();
//      p_stat.nb_hand = tmpweapon.nb_hand();
      p_stat.nb_max_attack = tmpweapon.nb_max_attack();
      p_stat.AD = p_stat.AD + tmpweapon.AD();
      p_stat.hitbonus = p_stat.hitbonus + tmpweapon.hitbonus();
      p_stat.elm_effect = ( p_stat.elm_effect & tmpitem.elmeffect() );
      p_stat.hlt_effect = ( p_stat.hlt_effect & tmpitem.hlteffect() );
      

      if ( tmpweapon.static_dmg() > 0 )
      {
         p_stat.dmg_y = tmpweapon.static_dmg();
      }
      else
         p_stat.dmg_z += STRmodifier();
      
      switch ( tmpweapon.attribute() )
      {
         case Weapon_ATTRIB_STR :
            p_stat.hitbonus += STRmodifier();//p_attribute [ Opponent_STRENGTH ];
         break;
         case Weapon_ATTRIB_INT :
            p_stat.hitbonus += INTmodifier();//p_attribute [ Opponent_INTELLIGENCE ];
         break;
         case Weapon_ATTRIB_DEX :
            p_stat.hitbonus += DEXmodifier(); //p_attribute [ Opponent_DEXTERITY ];
         break;
      }

   }
   else
   {   // bare hand combat

      p_stat.dmg_x += 1;
      p_stat.dmg_type = Weapon_DMGTYPE_NORMAL;
      p_stat.range = Weapon_RANGE_MELEE;
//      p_stat.nb_hand = 1;
      p_stat.nb_max_attack = 2;
//      p_stat.AD = p_stat.AD + 1;
      p_stat.hitbonus += STRmodifier();//p_attribute [ Opponent_STRENGTH ];
      p_stat.dmg_z += STRmodifier();

      tmpclass.DBselect ( p_cclass );
      if ( tmpclass.have_skill ( CClass_SKILL_MARTIALART ) == true )
      {
         p_stat.dmg_x += p_level / 5;
         p_stat.AD += p_level / 5;
         p_stat.nb_max_attack = 2 + ( p_level / 8 );
//         if ( p_stat.nb_max_attack > 5 )
//            p_stat.nb_max_attack = 5;
      }


   }

   for ( i = Character_EQUIP_HEAD ; i <= Character_EQUIP_OTHER ; i++ )
   {
      if ( p_equiped [ i ] != 0 )
      {
         tmpaccessory.DBselect ( p_equiped [ i ] );

         for ( j = 0 ; j < 3 ; j++ )
         {
            switch ( tmpaccessory.statID ( j ) )
            {
               case Accessory_STAT_NONE     :
               break;
               case Accessory_STAT_PD       :
                  p_stat.PD += tmpaccessory.bonus ();
               break;
               case Accessory_STAT_AD       :
                  p_stat.AD += tmpaccessory.bonus ();
               break;
               case Accessory_STAT_MPD      :
                  p_stat.MPD += tmpaccessory.bonus ();
               break;
               case Accessory_STAT_MAD      :
                  p_stat.MAD += tmpaccessory.bonus ();
               break;
               case Accessory_STAT_DR       :
                  p_stat.DR += tmpaccessory.bonus ();
               break;
               case Accessory_STAT_MDR      :
                  p_stat.MDR += tmpaccessory.bonus ();
               break;
               case Accessory_STAT_PSAVE    :
                  p_stat.PSAVE += tmpaccessory.bonus ();
               break;
               case Accessory_STAT_MSAVE    :
                  p_stat.MSAVE += tmpaccessory.bonus ();
               break;
               case Accessory_STAT_HIT      :
                  p_stat.hitbonus += tmpaccessory.bonus ();
               break;
               case Accessory_STAT_INIT      :
                  p_stat.init += tmpaccessory.bonus ();
               break;
               case Accessory_STAT_DMG_Z     :
                  p_stat.dmg_z += tmpaccessory.bonus ();
               break;
               case Accessory_STAT_MDMG_Z    :
                  p_stat.mdmg_z += tmpaccessory.bonus ();
               break;
            }
         }
      }
   }

}

void Character::eval_stat_encumbrance ( void )
{

   Item tmpitem;
   tiny i;
   p_weight = 0;

   for ( i = 0 ; i < Character_EQUIP_SIZE ; i++ )
   {
      if ( p_equiped [ i ] != 0 )
      {
         tmpitem.DBselect ( p_equiped [ i ] );
         p_weight += tmpitem.weight ();
      }
   }

   for ( i = 0 ; i < nb_inventory () ; i++ )
      if ( p_inventory [ i ] != 0 )
      {
         tmpitem.DBselect ( p_inventory [ i ] );
         p_weight += tmpitem.weight ();
      }
   
   //---------------  encumbrance -------------------
   p_encumbrance = ( p_weight * 100 ) / maxweight ();

   p_stat.encmod = p_encumbrance / 20;

//   p_stat.AD -= p_stat.encmod;

}

/*-------------------------------------------------------------------------*/
/*-                       Private Methods                                 -*/
/*-------------------------------------------------------------------------*/
/*-------------------------------------------------------------------------*/
/*-                       Virtual Methods                                 -*/
/*-------------------------------------------------------------------------*/


void Character::eval_stat_other ( void )
{
   eval_stat_race ();
   eval_stat_class ();
   eval_stat_equipment ();
   eval_stat_encumbrance ();
}

void Character::name_combat ( char *str )
{
   sprintf ( str, "%s the %s", p_name, p_reputation );
}
/*
void Character::save_vs ( Word healthID, tiny level )
{
   tiny tmpattrib;
   tiny value;
   word mask = 1;
   word tmphealth;
   tiny i;

   eval_stat_all();

   for ( i = 0 ; i < 16 ; i++ )
   {
      tmphealth = ( healthID & mask );

      if ( tmphealth > 0 )
      {

         if ( tmphealth > Opponent_PHYSICAL_HEALTH_LIMIT )
         {
            tmpattrib = p_attribute [ Character_WILLPOWER ] + p_stat.MSAVE;
         }
         else
            tmpattrib = p_attribute [ Character_ENDURANCE ] + p_stat.PSAVE;

         value = rnd(20) + ( level / 5 );

         if ( ( tmphealth & p_stat.hlt_resist ) == 0 ) // health resistance
         {
            if ( value > tmpattrib )
            {
               value = rnd(20) + ( level / 5 );
               // when a roll is failed, a luck roll is allowed
               if ( health ( Opponent_HEALTH_CURSED ) == false )
                  if ( value > p_attribute [ Character_LUCK ] )
                  {
                     add_health ( tmphealth );
                  }

            }
         }
      }
      mask = mask << 1;
   }
}
                                                                */

void Character::objdat_to_strdat ( void *dataptr )
{
   dbs_Character &tmpdat = *(static_cast<dbs_Character*> ( dataptr ));

   tiny i;
//   tiny j;

   Opponent::objdat_to_strdat ( dataptr );

   tmpdat.rank = p_rank;
   tmpdat.institution = p_institution;
   tmpdat.race = p_race.number();
   tmpdat.cclass = p_cclass.number();
   tmpdat.sex = p_sex;
   tmpdat.age = p_age;
   tmpdat.experience = p_experience;
   tmpdat.available = p_available;
   tmpdat.encumbrance = p_encumbrance;
   tmpdat.weight = p_weight;

   strncpy ( tmpdat.family, p_family, 16 );
   strncpy ( tmpdat.reputation, p_reputation, 16 );
   strncpy ( tmpdat.combatstr, p_combatstr, 13 );

   for ( i = 0 ; i < Character_INVENTORY_SIZE ; i++ )
      tmpdat.inventory [ i ] = p_inventory [ i ].number();

   for ( i = 0 ; i < Character_EQUIP_SIZE ; i++ )
      tmpdat.equiped [ i ] = p_equiped [ i ].number();

   tmpdat.nb_inventory = p_nb_inventory;
   tmpdat.nb_equiped = p_nb_equiped;
   
}

void Character::strdat_to_objdat ( void *dataptr )
{
   dbs_Character &tmpdat = *(static_cast<dbs_Character*> ( dataptr ));

   tiny i;
//   tiny j;
   Opponent::strdat_to_objdat ( dataptr );

   p_rank = tmpdat.rank;
   p_institution = tmpdat.institution;
   p_race.number ( tmpdat.race );
   p_cclass.number ( tmpdat.cclass );
   p_sex = tmpdat.sex;
   p_age = tmpdat.age;
   p_experience = tmpdat.experience;
   p_available = tmpdat.available;
   p_encumbrance = tmpdat.encumbrance;
   p_weight = tmpdat.weight;
   strcpy ( p_family, tmpdat.family );
   strcpy ( p_reputation, tmpdat.reputation );
   strcpy ( p_combatstr, tmpdat.combatstr );

   for ( i = 0 ; i < Character_INVENTORY_SIZE ; i++ )
      p_inventory [ i ].number(tmpdat.inventory [ i ]);
   for ( i = 0 ; i < Character_EQUIP_SIZE ; i++ )
      p_equiped [ i ].number(tmpdat.equiped [ i ]);
      
   p_nb_inventory = tmpdat.nb_inventory;
   p_nb_equiped = tmpdat.nb_equiped;

   
}

void Character::child_DBremove ( void )
{
   Item tmpitem;
   tiny i;

   for ( i = 0 ; i < Character_INVENTORY_SIZE ; i++ )
   {
      if ( p_inventory [ i ] != 0 )
      {
         tmpitem.DBselect (  p_inventory [ i ].number() );
         tmpitem.DBremove( );
      }
   }

   for ( i = 0 ; i < Character_EQUIP_SIZE ; i++ )
   {
      if ( p_equiped [ i ] != 0 )
      {
         tmpitem.DBselect (  p_equiped [ i ].number() );
         tmpitem.DBremove( );
      }
   }


/*   if ( p_weapon != 0 )
   {
      tmpitem.DBselect (  p_weapon.number() );
      tmpitem.DBremove ( );
   }
   if ( p_armor != 0 )
   {
      tmpitem.DBselect (  p_armor.number() );
      tmpitem.DBremove (  );
   }
   if ( p_shield != 0 )
   {
      tmpitem.DBselect (  p_shield.number() );
      tmpitem.DBremove ( );
   }
   if ( p_head != 0 )
   {
      tmpitem.DBselect (  p_head.number() );
      tmpitem.DBremove ( );
   }
   if ( p_feet != 0 )
   {
      tmpitem.DBselect (  p_feet.number() );
      tmpitem.DBremove ( );
   }
   if ( p_hand != 0 )
   {
      tmpitem.DBselect (  p_hand.number() );
      tmpitem.DBremove ( );
   }
   if ( p_other != 0 )
   {
      tmpitem.DBselect (  p_other.number() );
      tmpitem.DBremove ( );
   }                                   */

}





/*-------------------------------------------------------------------------*/
/*-                      Non Class Procedure                              -*/
/*-------------------------------------------------------------------------*/


