/**************************************************************************/
/*                                                                        */
/*                           C C L A S S . C P P                          */
/*                           Class source code                            */
/*                                                                        */
/*     Content : Class CClass source code                                 */
/*     Programmer : Eric Pietrocupo                                       */
/*     Starting Date : june 14th 2004                                     */
/*     License : GNU General Public LIcense                               */
/*                                                                        */
/**************************************************************************/

#include <general.h>

#include <stdio.h>
//#include <math.h>
//#include <stdlib.h>
//#include <time.h>
#include <allegro.h>
//#include <random.h>
#include <string.h>
//#include <datafile.h>
//#include <datmacro.h>
#include <system.h>
//#include <init.h>
#include <menu.h>
//#include <option.h>
//#include <screen.h>
//#include <dbdata.h>
//#include <dbtag.h>
//#include <database.h>
//#include <dbobject.h>
#include <ddt.h>
#include <dbdef.h>
#include <item.h>
#include <armor.h>
#include <weapon.h>
#include <shield.h>
#include <accesory.h>
#include <expandbl.h>
#include <list.h>
#include <race.h>
#include <cclass.h>
#include <opponent.h>
#include <charactr.h>
//#include <ennemy.h>
#include <account.h>
#include <party.h>
#include <player.h>
//#include <game.h>
//#include <city.h>
//#include <maze.h>
//#include <adventur.h>
//#include <camp.h>
//#include <config.h>
//#include <draw.h>
//#include <dialog.h>
//#include <combat.h>
#include <window.h>
#include <winmenu.h>
#include <winempty.h>
#include <wintitle.h>
#include <windata.h>
#include <wdatproc.h>
#include <winmessa.h>
#include <winquest.h>
#include <wininput.h>

/*------------------------------------------------------------------------*/
/*-                         Constructor & Destructor                     -*/
/*------------------------------------------------------------------------*/


CClass::CClass ( void )
{
   tiny i;

   strcpy ( p_name, "" );
   p_aligment_allowed = 0;
   p_elm_resist = 0;
   p_elm_effect = 0;
   p_hlt_effect = 0;
   p_magikproperty = 0;
   p_spell_element = 0;
   p_spell_amplification = 0;
//   p_wprof_range = 0;
//   p_wprof_attrib = 0;
//   p_wprof_nb_hand = 0;
   p_weapon_profiency = 0;
   p_armor_profiency = 0;
   p_shield_profiency = 0;
   p_DMGdiv = 0;
   p_MDMGdiv = 0;
   p_mulhitdiv = 0;
   p_baseAD = 0;
   p_baseMAD = 0;
   p_HPdiv = 0;
   p_MPdiv = 0;

   for ( i = 0 ; i < 3 ; i++ )
      p_skill [ i ] = 0;

   // must be set for DBObject to work properly
   p_dblength = sizeof ( dbs_CClass );
   p_dbtableID = DBTABLE_CCLASS;

}


CClass::~CClass ( void )
{

}

/*-------------------------------------------------------------------------*/
/*-                            Property Methods                           -*/
/*-------------------------------------------------------------------------*/

const char* CClass::name ( void )
{
   return ( p_name );
}

void CClass::name ( const char* value )
{
   strncpy ( p_name, value, 21 );
}

const char* CClass::initial ( void )
{
   return ( p_initial );
}

void CClass::initial ( const char* value )
{
   strncpy ( p_initial, value, 4 );
}

byte CClass::aligment_allowed ( void )
{
   return ( p_aligment_allowed );
}

void CClass::aligment_allowed ( tiny value )
{
   p_aligment_allowed = value;
}

word CClass::elm_resist ( void )
{
   return ( p_elm_resist );
}

void CClass::elm_resist ( word value )
{
   p_elm_resist = value;
}

word CClass::elm_effect ( void )
{
   return ( p_elm_effect );
}

void CClass::elm_effect ( word value )
{
   p_elm_effect = value;
}

word CClass::hlt_resist ( void )
{
   return ( p_hlt_resist );
}

void CClass::hlt_resist ( word value )
{
   p_hlt_resist = value;
}


word CClass::hlt_effect ( void )
{
   return ( p_hlt_effect );
}

void CClass::hlt_effect ( word value )
{
   p_hlt_effect = value;
}

word CClass::magikproperty ( void )
{
   return ( p_magikproperty );
}

void CClass::magikproperty ( word value )
{
   p_magikproperty = value;
}


byte CClass::spell_element ( void )
{
   return ( p_spell_element );
}

void CClass::spell_element ( byte value )
{
   p_spell_element = value;
}

tiny CClass::spell_amplification ( void )
{
   return ( p_spell_amplification );
}

void CClass::spell_amplification ( tiny value )
{
   p_spell_amplification = value;
}

tiny CClass::spell_progress ( void )
{
   return ( p_spell_progress );
}

void CClass::spell_progress ( tiny value )
{
   p_spell_progress = value;
}

tiny CClass::skill  ( tiny index )
{
   return ( p_skill [ index ] );
}

void CClass::skill  ( tiny index, tiny value )
{
   p_skill [ index ] = value;
}

bool CClass::have_skill ( tiny value )
{
   bool retval = false;
   tiny i;

   for ( i = 0 ; i < CClass_NB_MAX_SKILL ; i++ )
   {
      if ( p_skill [ i ] == value )
         retval = true;
   }

   return ( retval );
}

/*byte CClass::wprof_range ( void )
{
   return ( p_wprof_range );
}

void CClass::wprof_range ( byte value )
{
   p_wprof_range = value;
}

byte CClass::wprof_attrib ( void )
{
   return ( p_wprof_attrib );
}

void CClass::wprof_attrib ( byte value )
{
   p_wprof_attrib = value;
}

byte CClass::wprof_nb_hand ( void )
{
   return ( p_wprof_nb_hand );
}

void CClass::wprof_nb_hand ( byte value )
{
   p_wprof_nb_hand = value;
} */

byte CClass::weapon_profiency ( void )
{
   return ( p_weapon_profiency );
}

void CClass::weapon_profiency ( byte value )
{
   p_weapon_profiency = value;
}

tiny CClass::armor_profiency ( void )
{
   return ( p_armor_profiency );
}

void CClass::armor_profiency ( tiny value )
{
   p_armor_profiency = value;
}

tiny CClass::shield_profiency ( void )
{
   return ( p_shield_profiency );
}

void CClass::shield_profiency ( tiny value )
{
   value = p_shield_profiency ;
}
tiny CClass::DMGdiv ( void )
{
   return ( p_DMGdiv );
}

void CClass::DMGdiv ( tiny value )
{
   value = p_DMGdiv ;
}
tiny CClass::MDMGdiv ( void )
{
   return ( p_MDMGdiv );
}

void CClass::MDMGdiv ( tiny value )
{
   value = p_MDMGdiv;
}
tiny CClass::mulhitdiv ( void )
{
   return ( p_mulhitdiv );
}

void CClass::mulhitdiv ( tiny value )
{
   value = p_mulhitdiv;
}
tiny CClass::baseAD ( void )
{
   return ( p_baseAD );
}

void CClass::baseAD ( tiny value )
{
   value = p_baseAD;
}
tiny CClass::baseMAD ( void )
{
   return ( p_baseMAD );
}

void CClass::baseMAD ( tiny value )
{
   value = p_baseMAD ;
}

tiny CClass::HPdiv ( void )
{
   return ( p_HPdiv );
}

void CClass::HPdiv ( tiny value )
{
   value = p_HPdiv ;
}
tiny CClass::MPdiv ( void )
{
   return ( p_MPdiv );
}

void CClass::MPdiv ( tiny value )
{
   value = p_MPdiv ;
}


/*-------------------------------------------------------------------------*/
/*-                          Virtual Methods                              -*/
/*-------------------------------------------------------------------------*/

void CClass::objdat_to_strdat ( void *dataptr )
{
   tiny i;

   dbs_CClass &tmpdat = *(static_cast<dbs_CClass*> ( dataptr ));

   strncpy ( tmpdat.name , p_name , 21 );
   strncpy ( tmpdat.initial , p_initial , 4 );
   tmpdat.aligment_allowed = p_aligment_allowed;
   tmpdat.elm_resist = p_elm_resist;
   tmpdat.elm_effect = p_elm_effect;
   tmpdat.hlt_resist = p_hlt_resist;
   tmpdat.hlt_effect = p_hlt_effect;
   tmpdat.magikproperty = p_magikproperty;
   tmpdat.spell_element = p_spell_element;
   tmpdat.spell_amplification = p_spell_amplification;
   tmpdat.spell_progress = p_spell_progress;
/*   tmpdat.wprof_range = p_wprof_range;
   tmpdat.wprof_attrib = p_wprof_attrib;
   tmpdat.wprof_nb_hand = p_wprof_nb_hand;
   tmpdat.wprof_size = p_wprof_size;*/
   tmpdat.weapon_profiency = p_weapon_profiency;
   tmpdat.armor_profiency = p_armor_profiency;
   tmpdat.shield_profiency = p_shield_profiency;
   tmpdat.DMGdiv = p_DMGdiv;
   tmpdat.MDMGdiv = p_MDMGdiv;
   tmpdat.mulhitdiv = p_mulhitdiv;
   tmpdat.baseAD = p_baseAD;
   tmpdat.baseMAD = p_baseMAD;
   tmpdat.HPdiv = p_HPdiv;
   tmpdat.MPdiv = p_MPdiv;

   for ( i = 0 ; i < 3 ; i++ )
      tmpdat.skill [ i ] = p_skill [ i ];

}

void CClass::strdat_to_objdat ( void *dataptr )
{
   tiny i;
   dbs_CClass &tmpdat = *(static_cast<dbs_CClass*> ( dataptr ));

   strcpy ( p_name, tmpdat.name );
   strcpy ( p_initial, tmpdat.initial );
   p_aligment_allowed = tmpdat.aligment_allowed;
   p_elm_resist = tmpdat.elm_resist;
   p_elm_effect = tmpdat.elm_effect;
   p_hlt_resist = tmpdat.hlt_resist;
   p_hlt_effect = tmpdat.hlt_effect;
   p_magikproperty = tmpdat.magikproperty;
   p_spell_element = tmpdat.spell_element;
   p_spell_amplification = tmpdat.spell_amplification;
   p_spell_progress = tmpdat.spell_progress;
/*   p_wprof_range = tmpdat.wprof_range;
   p_wprof_attrib = tmpdat.wprof_attrib;
   p_wprof_nb_hand = tmpdat.wprof_nb_hand;
   p_wprof_size = tmpdat.wprof_size;*/
   p_weapon_profiency = tmpdat.weapon_profiency;
   p_armor_profiency = tmpdat.armor_profiency;
   p_shield_profiency = tmpdat.shield_profiency;
   p_DMGdiv = tmpdat.DMGdiv;
   p_MDMGdiv = tmpdat.MDMGdiv;
   p_mulhitdiv = tmpdat.mulhitdiv;
   p_baseAD = tmpdat.baseAD;
   p_baseMAD = tmpdat.baseMAD;
   p_HPdiv = tmpdat.HPdiv;
   p_MPdiv = tmpdat.MPdiv;
   

   for ( i = 0 ; i < 3 ; i++ )
      p_skill [ i ] = tmpdat.skill [ i ];


}

void CClass::child_DBremove ( void )
{

}

   
