/***************************************************************************/
/*                                                                         */
/*                             C A M P . C P P                             */
/*                            Class Source Code                            */
/*                                                                         */
/*     Content : Class Camp                                                */
/*     Programmer : Eric PIetrocupo                                        */
/*     Stating Date : May 10th, 2002                                       */
/*                                                                         */
/***************************************************************************/

#include <general.h>

//#include <stdio.h>
//#include <stdlib.h>
//#include <time.h>
#include <allegro.h> // try to remove
//#include <string.h>
#include <datafile.h>
#include <advdatf.h>
#include <datmacro.h>
#include <system.h> // to remove
//#include <init.h>
#include <menu.h>
#include <option.h>
//#include <screen.h>
//#include <dbdata.h>
//#include <dbtag.h>
//#include <database.h>
//#include <dbobject.h>
#include <ddt.h>
#include <dbdef.h>
#include <item.h>
//#include <armor.h>
#include <weapon.h>
#include <shield.h>
//#include <accesory.h>
//#include <expandbl.h>
//#include <list.h>
#include <race.h>
#include <opponent.h>
#include <charactr.h>
//#include <monster.h>
#include <party.h>
#include <player.h>
#include <game.h>
#include <account.h>
//#include <city.h>
//#include <maze.h>
//#include <adventur.h>
#include <camp.h>
#include <config.h>
#include <draw.h>
//#include <dialog.h>
//#include <combat.h>
#include <window.h>
#include <winmenu.h>
#include <winempty.h>
#include <wintitle.h>
#include <windata.h>
#include <wdatproc.h>
#include <winmessa.h>
//#include <winquest.h>

/*-------------------------------------------------------------------------*/
/*-                     Constructors & Destructors                        -*/
/*-------------------------------------------------------------------------*/

Camp::Camp ( void )
{
}

Camp::~Camp ( void )
{

}

/*-------------------------------------------------------------------------*/
/*-                                 Method                                -*/
/*-------------------------------------------------------------------------*/

tiny Camp::start ( DBTag party )
{
   bool exit_camp = false;
   tiny answer = 0;
   Menu p_mnu_camp; // main menu of the camp screen
   tiny retval = Camp_BACKTOMAZE;

   p_party.DBselect ( party );

//   save_backup_screen ();

   WinTitle wttl_title ("Camp");
//   p_mnu_camp.title ("Camp");

   p_mnu_camp.add_item ("Character");
   p_mnu_camp.add_item ("Search", true );
   p_mnu_camp.add_item ("Reorder", true );
   p_mnu_camp.add_item ("Diary", true );
   p_mnu_camp.add_item ("Options");
   p_mnu_camp.add_item ("Quit Party");
   p_mnu_camp.add_item ("Return");

   WinMenu mnu_camp ( p_mnu_camp, 250, 40 );
//   Window::instruction ( 320, 250 );

   play_music_track ( System_MUSIC_w1camp );

//   p_mnu_camp.unmask_all_item ();

   while ( exit_camp == false )
   {
      load_backup_screen ();
      draw_party_spell ( p_party );
//      draw_border_fill ( 194 , 24, 446, 236, General_COLOR_BORDER,
//         General_COLOR_FILL );
      Window::instruction ( 320, 330, Window_INSTRUCTION_MENU +
         Window_INSTRUCTION_SELECT + Window_INSTRUCTION_CANCEL );
      answer = Window::show_all();
//      answer = p_mnu_camp.show ( 200 , 30, answer );

      mnu_camp.hide();
      switch ( answer )
      {
         case -1 :
           exit_camp = true;
         break;

         case Camp_MENU_CHARACTER :
            show_character ();
         break;

         case Camp_MENU_SEARCH :
         break;
/*
         case Camp_MENU_SPELL :
         break;
         
         case Camp_MENU_MECHANICS :
         break;
         
         case Camp_MENU_HEAL :
         break;
         
         case Camp_MENU_USE_ITEM :
         break;
         
         case Camp_MENU_TRADE_ITEM :
         break;
         
         case Camp_MENU_FORMATION :
         break;*/

         case Camp_MENU_REORDER :
         break;
         
         case Camp_MENU_DIARY :
         break;

         case Camp_MENU_OPTION :
            config.start();
         break;

         case Camp_MENU_QUIT :
            exit_camp = true;
            retval = Camp_QUITPARTY;
         break;

         case Camp_MENU_CANCEL :
            exit_camp = true;
            retval = Camp_BACKTOMAZE;
         break;

         /*                     retval = City_END_GAME;
                     answer2 = -1;
*/
      }
      mnu_camp.unhide();
   }


   p_party.DBupdate();
   return ( retval );
}

/*-------------------------------------------------------------------------*/
/*-                         Private Methods                               -*/
/*-------------------------------------------------------------------------*/

void Camp::show_character ( void )
{
   Menu mnu_list;
   Menu mnu_character;
   tiny i;
   tiny answer;
   tiny answer2;
   tiny answer3;
   bool exit_list = false;
   bool exit_charmenu = false;
   short ystart;
   tiny nb_character = p_party.nb_character();
   tiny errval;
//   string tmpstr;
   char strmsg [ 241 ];
   Character tmpchar;

   mnu_character.add_item ("Equip Item" );
   mnu_character.add_item ("Unequip Item" );
   mnu_character.add_item ("Inspect Item" );
   mnu_character.add_item ("Drop Item" );
//   mnu_character.add_item ("Fighting Style");
   mnu_character.add_item ("Spell Book" );
//   mnu_character.add_item ("Combat Stats" );
   mnu_character.add_item ("Return" );

   ystart = 355 + 6 + 14;

   for ( i = 0 ; i < nb_character ; i++ )
      mnu_list.add_item ("");

   answer = 0;
   while ( exit_list == false )
   {
      WinData<Party> wdat_party_bar ( WDatProc_party_bar, p_party,
         WDatProc_POSITION_PARTY_BAR );
      load_backup_screen ();
      Window::instruction ( 320, 330 );

      Window::draw_all();
      draw_party_spell ( p_party );

      answer = mnu_list.show ( 6, ystart , answer );

      if ( answer == -1 )
         exit_list = true;
      else
      {
         answer2 = 0;
         exit_charmenu = false;
         while ( exit_charmenu == false )
         {
            mnu_character.unmask_all_item();
            tmpchar.DBselect (p_party.character ( answer ) );
            WinData<Character> wdat_character
               ( WDatProc_character, tmpchar, WDatProc_POSITION_CHARACTER );

            WinMenu wmnu_character ( mnu_character, 476, 350 );

            Window::instruction ( 320, 460 );


     //       mnu_character.mask_item ( Camp_CHARMENU_STYLE );
            mnu_character.mask_item ( Camp_CHARMENU_READ );

            if ( tmpchar.nb_inventory () <= 0 )
            {
               mnu_character.mask_item ( Camp_CHARMENU_INSPECT );
               mnu_character.mask_item ( Camp_CHARMENU_DROP );
               mnu_character.mask_item ( Camp_CHARMENU_EQUIP );
//               mnu_character.mask_item ( Camp_CHARMENU_USE );
            }
            if ( tmpchar.nb_equiped () <= 0 )
               mnu_character.mask_item ( Camp_CHARMENU_UNEQUIP );

            answer2 = Window::show_all();

            answer3 = 0;

            switch ( answer2 )
            {
            
               case Camp_CHARMENU_EQUIP :
                  while ( answer3 != -1
                     && tmpchar.nb_inventory () > 0 )
                  {
                     answer3 = show_select_inventory ( tmpchar );
                     if ( answer3 != -1 )
                     {
                        errval = tmpchar.equip_item ( answer3 );
                        if ( errval != Character_ITEM_SUCCESSFULL )
                        {
                           WinMessage wmsg_error ( STR_ITM_EQUIPERR [ errval ] );
                           Window::show_all();
                        }
                     }
                  }
               break;

               case Camp_CHARMENU_UNEQUIP :
               while ( answer3 != -1 )
                  {
                     answer3 = show_select_equipment ( tmpchar );
                     if ( answer3 != -1 )
                     {
                        errval = tmpchar.unequip_item ( answer3 );
                        if ( errval != 0 )
                        {
                           WinMessage wmsg_error ( STR_ITM_EQUIPERR [ errval ] );
                           Window::show_all();
                        }
                     }
                  }
               
               break;
               
               case Camp_CHARMENU_INSPECT :
                  while ( answer3 != -1 )
                  {
                     answer3 = show_select_inventory ( tmpchar );
                     if ( answer3 != -1 )
                     {
                        show_inspect_item ( tmpchar, answer3 );
                     }
                  }
                  
               break;

/*               case Camp_CHARMENU_USE :
               while ( answer3 != -1 )
               {
                  answer3 = show_select_inventory ( tmpchar );
                  if ( answer3 != -1 )
                     show_use_item ( tmpchar, answer3 );
               }
               break;*/
               
               case Camp_CHARMENU_DROP :
                  while ( answer3 != -1
                     && tmpchar.nb_inventory () > 0 )
                  {
                     answer3 = show_select_inventory ( tmpchar );
                     if ( answer3 != -1 )
                        tmpchar.delete_inventory ( answer3 );
                  }
               break;
               
/*               case Camp_CHARMENU_STYLE :
                  show_fighting_style ( tmpchar );
               break;*/
               
               case Camp_CHARMENU_READ :
                  show_read_spell ( tmpchar );
               break;

/*               case Camp_CHARMENU_STAT :
                  show_combat_stat ( tmpchar );
               break;*/

               case Camp_CHARMENU_CANCEL :
               case -1 :
                  exit_charmenu = true;
               break;
            }

            tmpchar.DBupdate();
         }
      }
   }
}

tiny Camp::show_select_inventory ( Character &tmpchar )
{
   tiny answer = 0;
   tiny i;
   tiny nb_item;
//   Character tmpcharacter;
//   Item *tmpitem;
//   Character tmpcharacter;

//   tmpcharacter.DBselect ( p_party.character ( characterID ) );

   Menu mnu_inventory;

   nb_item = tmpchar.nb_inventory();
   
   if ( nb_item > 0 )
   {
      for ( i = 0 ; i < nb_item ; i++ )
         mnu_inventory.add_item ("");

      Window::instruction ( 320, 460, Window_INSTRUCTION_MENU +
         Window_INSTRUCTION_SELECT + Window_INSTRUCTION_CANCEL );

      Window::refresh_all();
      Window::draw_all();
//      draw_character ( tmpcharacter );


      answer = mnu_inventory.show ( 218, 58 );
   }
   else
      return ( -1 );
   
   return ( answer );
}

tiny Camp::show_select_equipment ( Character &tmpchar )
{
   tiny answer = 0;
   tiny i;
//   Item *tmpitem;
//   Character tmpcharacter;
//   bool masklist [ 8 ];
//   Character tmpcharacter;

//   tmpcharacter.DBselect ( p_party.character ( characterID ) );

   Menu mnu_equipment;

//   for ( i = 0 ; i < 8 ; i++ )
//      masklist [ i ] = false;

//   if ( tmpchar.weaponA () == 0 ) masklist [ 0 ] = true;
//   if ( tmpchar.weaponB () == 0 ) masklist [ 1 ] = true;
//   if ( tmpchar.shield () == 0 ) masklist [ 2 ] = true;
//   if ( tmpchar.armor () == 0 ) masklist [ 3 ] = true;
//   if ( tmpchar.head () == 0 ) masklist [ 4 ] = true;
//   if ( tmpchar.hand () == 0 ) masklist [ 5 ] = true;
//   if ( tmpchar.feet () == 0 ) masklist [ 6 ] = true;
//   if ( tmpchar.other () == 0 ) masklist [ 7 ] = true;
   
   for ( i = 0 ; i < 7 ; i++ )
      mnu_equipment.add_item ("" );

   Window::instruction ( 320, 460, Window_INSTRUCTION_MENU +
      Window_INSTRUCTION_SELECT + Window_INSTRUCTION_CANCEL );

   Window::refresh_all();
   Window::draw_all();
//   draw_character ( tmpcharacter );

   answer = mnu_equipment.show ( 218, 250 );

   return ( answer );

}

void Camp::show_inspect_item ( Character &tmpchar, tiny inventoryID )
{
   Item tmpitem;

   tmpitem.DBselect ( tmpchar.inventory ( inventoryID ) );

   WinData<Item> wdat_item ( WDatProc_inspect_item,
      tmpitem, WDatProc_POSITION_INSPECT_ITEM );

   Window::instruction ( 320, 380, Window_INSTRUCTION_CANCEL );
   Window::show_all();
   copy_buffer();
   while ((readkey() >> 8) != CANCEL_KEY );
}
/*
void Camp::show_use_item ( Character &tmpchar, tiny inventoryID )
{
   Item tmpitem;
   string tmpstr;
   s_Item_ability tmpablt;
   dword value;

   tmpitem.DBselect ( tmpchar.inventory ( inventoryID ) );
   tmpablt = tmpitem.ability();

   if ( tmpablt.type != Item_ABILITY_NONE )
   {
      value = tmpchar.use_ability ( inventoryID );
      //?? add other interpretation : maybe common with item abilityS()
      tmpstr = ABILITY_INFO [ tmpablt.type ] . name;
      tmpstr += value;
   }
   else
      tmpstr ="No Effect !";
      
   WinMessage wmsg_effect ( tmpstr );

   Window::instruction ( 320, 380, Window_INSTRUCTION_CANCEL );
   Window::show_all();
   copy_buffer();
   while ((readkey() >> 8) != CANCEL_KEY );

}
  */
  /*
void Camp::show_fighting_style ( Character &tmpchar )
{
   Weapon tmpw1;
   Weapon tmpw2;
   Shield tmps;
   Menu mnu_wpnA ( "Select Fighting style A" );
   Menu mnu_wpnB ( "Select Fighting style B" );
   byte fstyleval [ 4 ];
   string tmpstr;
   tiny listidx;
   tiny answer;
   tiny i;

   // weapon A style
   for ( i = 0 ; i < 4 ; i++ )
      fstyleval [ i ] = 0;
   
   listidx = 0;
   if ( tmpchar.weaponA() != 0 )
   {
      tmpw1.DBselect ( tmpchar.weaponA() );
      
      fstyleval [ listidx ] = Character_FSTYLE_WEAPONA;
      mnu_wpnA.add_item ( tmpw1.name() );
      listidx++;

      if ( tmpw1.nb_hand() == Weapon_ONEHANDED )
      {
         if ( tmpchar.shield() != 0 )
         {
            tmps.DBselect ( tmpchar.shield() );
            tmpstr = tmpw1.name() + " & ";
            tmpstr += tmps.name();
            fstyleval [ listidx ] = Character_FSTYLE_WEAPONA_SHIELD;
            mnu_wpnA.add_item ( tmpstr );
            listidx++;
         }

         if ( tmpchar.weaponB () != 0 )
         {
            tmpw2.DBselect ( tmpchar.weaponB () );

            if ( tmpw2.nb_hand () == Weapon_ONEHANDED )
            {
               tmpstr = tmpw1.name() + " & ";
               tmpstr += tmpw2.name();
               fstyleval [ listidx ] = Character_FSTYLE_WEAPONA_WEAPONB;
               mnu_wpnA.add_item ( tmpstr );
               listidx++;
            }
         }
      }
   }
   else
   {
      if ( tmpchar.shield() != 0 )
      {
         tmps.DBselect ( tmpchar.shield() );

         tmpstr += tmps.name();
         fstyleval [ listidx ] = Character_FSTYLE_SHIELD;
         mnu_wpnA.add_item ( tmps.name() );
         listidx++;
      }
   }

   if ( mnu_wpnA.nb_item () > 0 )
   {
      WinMenu wmnu_wpnA ( mnu_wpnA, 100, 200, true );
      answer = Window::show_all();
      tmpchar.fstyle ( 0 , fstyleval [ answer ] );
   }
   else
      tmpchar.fstyle ( 0 , Character_FSTYLE_NONE );


   // weapon B style
   for ( i = 0 ; i < 4 ; i++ )
      fstyleval [ i ] = 0;

   listidx = 0;
   if ( tmpchar.weaponB() != 0 )
   {
      tmpw1.DBselect ( tmpchar.weaponB() );
      
      fstyleval [ listidx ] = Character_FSTYLE_WEAPONB;
      mnu_wpnB.add_item ( tmpw1.name() );
      listidx++;

      if ( tmpw1.nb_hand() == Weapon_ONEHANDED )
      {
         if ( tmpchar.shield() != 0 )
         {
            tmps.DBselect ( tmpchar.shield() );
            tmpstr = tmpw1.name() + " & ";
            tmpstr += tmps.name();
            fstyleval [ listidx ] = Character_FSTYLE_WEAPONB_SHIELD;
            mnu_wpnB.add_item ( tmpstr );
            listidx++;
         }

         if ( tmpchar.weaponA () != 0 )
         {
            tmpw2.DBselect ( tmpchar.weaponA () );

            if ( tmpw2.nb_hand () == Weapon_ONEHANDED )
            {
               tmpstr = tmpw1.name() + " & ";
               tmpstr += tmpw2.name();
               fstyleval [ listidx ] = Character_FSTYLE_WEAPONA_WEAPONB;
               mnu_wpnB.add_item ( tmpstr );
               listidx++;
            }
         }
      }
   }
   else
   {
      if ( tmpchar.shield() != 0 )
      {
         tmps.DBselect ( tmpchar.shield() );

         tmpstr += tmps.name();
         fstyleval [ listidx ] = Character_FSTYLE_SHIELD;
         mnu_wpnB.add_item ( tmps.name() );
         listidx++;
      }
   }

   if ( mnu_wpnB.nb_item () > 0 )
   {
      WinMenu wmnu_wpnB ( mnu_wpnB, 100, 200, true );
      answer = Window::show_all();
      tmpchar.fstyle ( 1 , fstyleval [ answer ] );
   }
   else
      tmpchar.fstyle ( 1 , Character_FSTYLE_NONE );

}   */

void Camp::show_read_spell ( Character &tmpchar )
{

}

void Camp::show_combat_stat ( Character &tmpchar )
{
   WinData<Character> wdat_character ( WDatProc_character_stat,
                      tmpchar, WDatProc_POSITION_CHARACTER );
                      
   Window::instruction ( 550, 460, Window_INSTRUCTION_CANCEL );
   Window::draw_all();
   copy_buffer();
   while ((readkey() >> 8) != CANCEL_KEY );

}

