/***************************************************************************/
/*                                                                         */
/*                           A R M O R . C P P                             */
/*                                                                         */
/*     Content : Class Armor                                               */
/*     Programmer : Eric Pietrocupo                                        */
/*     Starting Date : June 5th, 2002                                      */
/*                                                                         */
/***************************************************************************/

#include <general.h>

//#include <stdio.h>
//#include <stdlib.h>
//#include <time.h>
//#include <allegro.h>
#include <string.h>
//#include <datafile.h>
//#include <datmacro.h>
//#include <system.h>
//#include <init.h>
//#include <menu.h>
//#include <option.h>
//#include <screen.h>
//#include <dbdata.h>
//#include <dbtag.h>
//#include <database.h>
//#include <dbobject.h>
#include <ddt.h>
#include <dbdef.h>
#include <item.h>
#include <armor.h>
//#include <weapon.h>
//#include <shield.h>
//#include <accesory.h>
//#include <expandbl.h>
//#include <list.h>
//#include <opponent.h>
//#include <charactr.h>
//#include <monster.h>
//#include <party.h>
//#include <player.h>
//#include <game.h>
//#include <city.h>
//#include <maze.h>
//#include <adventur.h>
//#include <camp.h>
//#include <config.h>
//#include <draw.h>
//#include <dialog.h>
//#include <combat.h>

/*-------------------------------------------------------------------------*/
/*-                       Constructor & Destructor                        -*/
/*-------------------------------------------------------------------------*/

Armor::Armor ( void )
{
   tiny i;

   p_type = Item_TYPE_ARMOR;
   p_PD = 0;
   p_AD = 0;
   p_DR = 0;
   p_MPD = 0;
   p_MDR = 0;
   p_category = 0;

   p_dblength = sizeof ( dbs_Armor );
   p_dbtableID = DBTABLE_ITEM;
}

Armor::~Armor ( void )
{

}


/*-------------------------------------------------------------------------*/
/*-                          Property Methods                             -*/
/*-------------------------------------------------------------------------*/

tiny Armor::PD ( void )
{
   return ( p_PD );
}

void Armor::PD ( tiny value )
{
   p_PD = value;
}

tiny Armor::AD ( void )
{
   return ( p_AD );
}

void Armor::AD ( tiny value )
{
   p_AD = value;
}

tiny Armor::DR ( void )
{
   return ( p_DR );
}

void Armor::DR ( tiny value )
{
   p_DR = value;
}

tiny Armor::MPD ( void )
{
   return ( p_MPD );
}

void Armor::MPD ( tiny value )
{
   p_MPD = value;
}

tiny Armor::MDR ( void )
{
   return ( p_MDR );
}

void Armor::MDR ( tiny value )
{
   p_MDR = value;
}

tiny Armor::category ( void )
{
   return ( p_category );
}

void Armor::category ( tiny value )
{
   p_category = value;
}

/*-------------------------------------------------------------------------*/
/*-                               Methods                                 -*/
/*-------------------------------------------------------------------------*/


/*-------------------------------------------------------------------------*/
/*-                           Private Methods                             -*/
/*-------------------------------------------------------------------------*/

/*-------------------------------------------------------------------------*/
/*-                           Virtual Methods                             -*/
/*-------------------------------------------------------------------------*/

void Armor::objdat_to_strdat ( void *dataptr )
{
   dbs_Armor &tmpdat = *(static_cast<dbs_Armor*> ( dataptr ));

   Item::objdat_to_strdat ( dataptr );

   tmpdat.PD = p_PD;
   tmpdat.AD = p_AD;
   tmpdat.DR = p_DR;
   tmpdat.MPD = p_MPD;
   tmpdat.MDR = p_MDR;
   tmpdat.category = p_category;
}

void Armor::strdat_to_objdat ( void *dataptr )
{
   dbs_Armor &tmpdat = *(static_cast<dbs_Armor*> ( dataptr ));

   Item::strdat_to_objdat ( dataptr );

   p_PD = tmpdat.PD;
   p_AD = tmpdat.AD;
   p_DR = tmpdat.DR;
   p_MPD = tmpdat.MPD;
   p_MDR = tmpdat.MDR;
   p_category = tmpdat.category;
}

void Armor::child_DBremove ( void )
{
   // no child to remove
}







