/***************************************************************************/
/*                                                                         */
/*                         A D V E N T U R E . C P P                       */
/*                             Class Source Code                           */
/*                                                                         */
/*     Content : Class Adventure source code                               */
/*     Programmer: Eric Pietrocupo                                         */
/*     Starting date : January 17th, 2004                                  */
/*     Licence : Gnu General Public License                                */
/*                                                                         */
/***************************************************************************/

#include <general.h>

#include <stdio.h>
//#include <stdlib.h>
//#include <time.h>
#include <allegro.h>
#include <string.h>
#include <datafile.h>
#include <advdatf.h>
#include <datmacro.h>
#include <system.h> // to remove
//#include <init.h>
//#include <menu.h>
//#include <option.h>
//#include <screen.h>
//#include <dbdata.h>
//#include <dbtag.h>
//#include <database.h>
//#include <dbobject.h>
#include <ddt.h>
#include <dbdef.h>
#include <adventur.h>
//#include <item.h>
//#include <armor.h>
//#include <weapon.h>
//#include <shield.h>
//#include <accesory.h>
//#include <expandbl.h>
//#include <list.h>
//#include <opponent.h>
//#include <charactr.h>
//#include <monster.h>
//#include <party.h>
//#include <player.h>
#include <game.h>
//#include <account.h>
//#include <city.h>
//#include <maze.h>
//#include <adventur.h>
//#include <camp.h>
//#include <config.h>
//#include <draw.h>
//#include <dialog.h>
//#include <combat.h>
//#include <window.h>
//#include <winmenu.h>
//#include <winempty.h>
//#include <wintitle.h>
//#include <windata.h>
//#include <wdatproc.h>
//#include <winmessa.h>
//#include <winquest.h>


/*-------------------------------------------------------------------------*/
/*-                    Constructor & destructor                           -*/
/*-------------------------------------------------------------------------*/

Adventure::Adventure ( void )
{
   strcpy ( p_saganame, "" );
   strcpy ( p_adventurename, "");
   p_episode = 1;
   strcpy ( p_authorname,"");
   strcpy ( p_version, "");
   strcpy ( p_date, "");
   strcpy ( p_import_password,"");
   strcpy ( p_export_password,"");

   p_dblength = sizeof ( dbs_Adventure );
   p_dbtableID = DBTABLE_ADVENTURE;
}

Adventure::~Adventure ( void )
{

}

/*-------------------------------------------------------------------------*/
/*-                             Property methods                          -*/
/*-------------------------------------------------------------------------*/

/*string& Adventure::saganame ( void )
{
   return ( p_saganame );
} */

const char* Adventure::saganame ( void )
{
   return ( p_saganame );
}

/*string& Adventure::adventurename ( void )
{
   return ( p_adventurename );
} */

const char* Adventure::adventurename ( void )
{
   return ( p_adventurename );
}

tiny Adventure::episode ( void )
{
   return ( p_episode );
}

/*string& Adventure::authorname ( void )
{
   return ( p_authorname );
} */

const char* Adventure::authorname ( void )
{
   return ( p_authorname );
}

/*string& Adventure::version ( void )
{
   return ( p_version );
} */

const char* Adventure::version ( void )
{
   return ( p_version );
}

/*string& Adventure::date ( void )
{
   return ( p_date );
} */

const char* Adventure::date ( void )
{
   return ( p_date );
}

/*string& Adventure::importpasswd ( void )
{
   return ( p_import_password );
} */

const char* Adventure::importpasswd ( void )
{
   return ( p_import_password );
}

/*string& Adventure::exportpasswd ( void )
{
   return ( p_export_password );
} */

const char* Adventure::exportpasswd ( void )
{
   return ( p_export_password );
}

/*string& Adventure::filename ( void )
{
   return ( p_filename );
} */

const char* Adventure::filename ( void )
{
   return ( p_filename );
}

/*void Adventure::filename ( string &str )
{
   p_filename = str;
} */

void Adventure::filename ( const char* str )
{
   strncpy ( p_filename, str, 23 );
}

/*-------------------------------------------------------------------------*/
/*-                            Methods                                    -*/
/*-------------------------------------------------------------------------*/

void Adventure::show_intro ( void )
{
   short i;
   char textline [ 41 ];
   char *textptr;
   BITMAP *textbmp = create_bitmap ( 360, 510 );
   bool changeimg = false;
   bool nomoretext = false;
   short j;
   tiny imgcount = 0;
   short l;
   short tmpl;
   short x;
   short y;
   short xrel;
   short yrel;
   

   BITMAP *buf1 = create_bitmap ( 640, 480 );
   BITMAP *buf2 = create_bitmap ( 640, 480 );

   play_music_track ( System_MUSIC_w2intro );

   clear_to_color ( buf1, makecol ( 0, 0, 0 ) );
   clear_to_color ( buf2, makecol ( 0, 0, 0 ) );

   // buffer 1
   textout_centre ( buf1, FNT_elgar32, "W i z a r d r y    L e g a c y",
      320, 200, makecol ( 255, 100, 100 ) );

   textout_centre ( buf1, FNT_kaufman24, p_authorname, 320, 300
      , General_COLOR_TEXT );

   textout_centre ( buf1, FNT_ambrosia24, "Presents", 320, 330
      , General_COLOR_TEXT );

   // buffer 2

   textout_centre ( buf2, FNT_blackchancery24, p_adventurename, 320, 100,
      General_COLOR_TEXT );

   textout_centre ( buf2, FNT_elgar32, p_saganame, 320, 200,
      General_COLOR_TEXT );

   if ( p_episode != 0 )
      textprintf_centre ( buf2, FNT_ambrosia24, 320, 240, General_COLOR_TEXT,
         "Episode %d", p_episode );

   textprintf ( buf2, FNT_helvetica22, 0, 450, General_COLOR_TEXT, "Version %s",
      p_version );

   textout ( buf2, FNT_helvetica22, p_date, 400, 450, General_COLOR_TEXT );


   vsync();
   blit ( buf1, screen, 0, 0, 0, 0, 640, 480 );

   rest ( 5000 );

   for ( i = 1 ; i <= 160 ; i++ )
   {
      blit ( buf1, buffer, 0, 0, 0 , 0 - ( i * 3 ), 640, 480 );
      blit ( buf2, buffer, 0, 0, 0, 480 - ( i * 3 ), 640, 480 );
      vsync();      
      blit ( buffer, screen, 0, 0, 0, 0, 640, 480 );
      rest ( 1 );
   }

   rest ( 5000 );

   for ( i = 1 ; i <= 160 ; i++ )
   {

      blit ( buf2, buffer, 0, 0, 0, 0 - ( i * 3 ), 640, 480 );
      vsync();      
      blit ( buffer, screen, 0, 0, 0, 0, 640, 480 );      
      rest ( 1 );
   }

   clear_bitmap ( screen );
   clear_bitmap ( buffer );
   clear_bitmap ( buf1 );
   clear_bitmap ( buf2 );
//   short linex [ 20 ];
//   char linechar [ 20 ] [ 31 ];

   clear_bitmap ( textbmp );

   for ( j = 0 ; j < 4 ; j++ )
   {
      switch ( j )
      {
         case 0 :
         textout_centre ( textbmp, FNT_helena24, p_saganame, 180, 480, General_COLOR_TEXT );
         break;
         case 1 :
         if ( p_episode != 0 )
         textprintf_centre ( textbmp, FNT_helena24, 180, 480, General_COLOR_TEXT,
            "           Episode %d         ", p_episode );
         break;
         case 2 :
         textout_centre ( textbmp, FNT_helena24, p_adventurename, 180, 480, General_COLOR_TEXT );
         break;
         case 3 :
   //      textout ( textbmp, FNT_helena24, "    -    1    -    2    -    3    -    4    -    5"
//            , 0, 480, General_COLOR_TEXT );
         break;
      }
      
      for ( i = 0 ; i < 24 ; i++ )
      {
         blit ( textbmp, textbmp, 0, 1, 0, 0, 360, 510 );
         vsync ();
         blit ( textbmp, screen, 0, 0, 0, 0, 360, 480 );
         rest(35);
      }
   }

   blit ( BMP_astory000, buf1, 0, 0, 0, 0, 240, 360 );
//   blit ( (BITMAP*) datf [ BMP_ENNEMY000 + imgcount ] . dat, buf2,
//       0, 0, 0, 0, 128, 128 );

   blit ( buf1, screen, 0, 0, 380, 60, 240, 360 );

   textptr = TXT_astory;
   while ( nomoretext == false )
   {
      // copy text
      i = 0;
      while ( *textptr != '\n' && i < 40 )
      {
         if ( *textptr != '\n' && *textptr != '\r' )
         {
            textline [ i ] = *textptr;
            i++;
         }
         textptr++;

      }
      textline [ i ] = '\0';
      textptr++;

      // check for code
      if ( strcmp ( textline, "<NEXTIMAGE>" ) == 0 )
      {
         imgcount++;
         blit ( (BITMAP*) adatf [ BMP_ASTORY000 + imgcount ] . dat, buf2,
            0, 0, 0, 0, 240, 360 );
//         blit ( (BITMAP*) datf [ BMP_ENNEMY000 + imgcount ] . dat, buf2,
//            0, 0, 0, 0, 128, 128 );

         changeimg = true;
//         if ( imgcount == 1 )
//            make_screen_shot ("storshot.bmp");//@@
      }
      if ( strcmp ( textline, "<ENDSTORY>" ) == 0 )
         nomoretext = true;

      if ( nomoretext == false )
      {
         l = 0;
         if ( changeimg != true )
            textout ( textbmp, FNT_blackchancery24, textline, 0, 480, General_COLOR_TEXT );
//            textout ( textbmp, FNT_helena24, textline, 0, 480, General_COLOR_TEXT );
         for ( i = 0 ; i < 24 ; i++ )
         {

            blit ( textbmp, textbmp, 0, 1, 0, 0, 360, 510 );
            if ( changeimg == true )
            {
               // image blitting

               if ( i < 16 )
               {

 //                 for ( k = 0 ; k < 16 ; k++ )
//                  {
                  // calculating correct l value;

                  if ( l > 15 )
                     l = l - 16;
      
                  // interpretation of relative pixel
                  tmpl = l;
                  xrel = 0;
                  yrel = 0;
                  while ( tmpl > 3 )
                  {
                     yrel++;
                     tmpl = tmpl - 4;
                  }
                  xrel = tmpl;
         
                  // draw the pixel
                  for ( y = 0 ; y < 360 ; y = y + 4 )
                     for ( x = 0 ; x < 240 ; x = x + 4 )
                        putpixel ( buf1, x + xrel, y + yrel, getpixel ( buf2, x + xrel, y+ yrel ) );

                  // incrementing l;
                  l = l + 7;
               }
            }
            vsync ();
            blit ( textbmp, screen, 0, 0, 0, 0, 360, 480 );
            if ( changeimg == true && i < 16 )
               blit ( buf1, screen, 0, 0, 380, 60, 240, 360 );
            rest(35);
         }
      }
      changeimg = false;
   }

   // scrool rest

   for ( i = 0 ; i < 480 ; i++ )
   {
      blit ( textbmp, textbmp, 0, 1, 0, 0, 360, 510 );
      vsync ();
      blit ( textbmp, screen, 0, 0, 0, 0, 360, 480 );
      rest ( 35 );
   }

   clear_bitmap ( screen );
   clear_bitmap ( buffer );

   destroy_bitmap ( textbmp );
   destroy_bitmap ( buf1 );
   destroy_bitmap ( buf2 );
   rest ( 1000 );
   stop_midi();
   rest ( 1000 );
}

void Adventure::show_ending ( void )
{
   short i;
   char textline [ 41 ];
   char *textptr;
   BITMAP *textbmp = create_bitmap ( 360, 510 );
   bool changeimg = false;
   bool nomoretext = false;
   short j;
   tiny imgcount = 0;
   short l;
   short tmpl;
   short x;
   short y;
   short xrel;
   short yrel;

   BITMAP *buf1 = create_bitmap ( 640, 480 );
   BITMAP *buf2 = create_bitmap ( 640, 480 );
   clear_bitmap ( textbmp );

   play_midi ( MID_music025, 1 );

// End Story

   blit ( BMP_aendstory000, buf1, 0, 0, 0, 0, 240, 360 );
//   blit ( (BITMAP*) datf [ BMP_ENNEMY000 + imgcount ] . dat, buf2,
//       0, 0, 0, 0, 128, 128 );

   blit ( buf1, screen, 0, 0, 380, 60, 240, 360 );

   textptr = TXT_aendstory;
   while ( nomoretext == false )
   {
      // copy text
      i = 0;
      while ( *textptr != '\n' && i < 40 )
      {
         if ( *textptr != '\n' && *textptr != '\r' )
         {
            textline [ i ] = *textptr;
            i++;
         }
         textptr++;

      }
      textline [ i ] = '\0';
      textptr++;

      // check for code
      if ( strcmp ( textline, "<NEXTIMAGE>" ) == 0 )
      {
         imgcount++;
         blit ( (BITMAP*) adatf [ BMP_ASTORY000 + imgcount ] . dat, buf2,
            0, 0, 0, 0, 240, 360 );
//         blit ( (BITMAP*) datf [ BMP_ENNEMY000 + imgcount ] . dat, buf2,
//            0, 0, 0, 0, 128, 128 );

         changeimg = true;
      }
      if ( strcmp ( textline, "<ENDSTORY>" ) == 0 )
         nomoretext = true;

      if ( nomoretext == false )
      {
         l = 0;
         if ( changeimg != true )
//            textout ( textbmp, FNT_helena24, textline, 0, 480, General_COLOR_TEXT );
            textout ( textbmp, FNT_blackchancery24, textline, 0, 480, General_COLOR_TEXT );
         for ( i = 0 ; i < 24 ; i++ )
         {

            blit ( textbmp, textbmp, 0, 1, 0, 0, 360, 510 );
            if ( changeimg == true )
            {
               // image blitting

               if ( i < 16 )
               {

 //                 for ( k = 0 ; k < 16 ; k++ )
//                  {
                  // calculating correct l value;

                  if ( l > 15 )
                     l = l - 16;
      
                  // interpretation of relative pixel
                  tmpl = l;
                  xrel = 0;
                  yrel = 0;
                  while ( tmpl > 3 )
                  {
                     yrel++;
                     tmpl = tmpl - 4;
                  }
                  xrel = tmpl;
         
                  // draw the pixel
                  for ( y = 0 ; y < 360 ; y = y + 4 )
                     for ( x = 0 ; x < 240 ; x = x + 4 )
                        putpixel ( buf1, x + xrel, y + yrel, getpixel ( buf2, x + xrel, y+ yrel ) );

                  // incrementing l;
                  l = l + 7;
               }
            }
            vsync ();
            blit ( textbmp, screen, 0, 0, 0, 0, 360, 480 );
            if ( changeimg == true && i < 16 )
               blit ( buf1, screen, 0, 0, 380, 60, 240, 360 );
            rest(35);
         }
      }
      changeimg = false;
   }

   // scrool rest

   for ( i = 0 ; i < 480 ; i++ )
   {
      blit ( textbmp, textbmp, 0, 1, 0, 0, 360, 510 );
      vsync ();
      blit ( textbmp, screen, 0, 0, 0, 0, 360, 480 );
      rest ( 35 );
   }

   clear_bitmap ( screen );
   clear_bitmap ( buffer );

   stop_midi ();

   rest ( 2000 );


// Congratulation

   play_midi ( MID_music019, 0 );

   textout_centre ( buffer, FNT_helena24, "C o n g r a t u l a t i o n s",
      320, 100, makecol ( 230, 150, 150 ) );

   textout_centre ( buffer, FNT_ambrosia24, "You have succesfully completed",
      320, 200, makecol ( 230, 230, 150 ) );

   textout_centre ( buffer, FNT_elgar32, p_adventurename,
      320, 300, makecol ( 150, 230, 230 ) );
      
   textout_centre ( buffer, FNT_elgar32, p_saganame,
      320, 350, makecol ( 150, 230, 150 ) );

   if ( p_episode != 0 )
      textprintf_centre ( buffer, FNT_elgar32, 320, 400,
         makecol ( 150, 230, 150 ), "Episode %d", p_episode );

   vsync();
   blit ( buffer, screen, 0, 0, 0, 0, 640, 480 );

   rest ( 5000 );

   for ( i = 0 ; i < 160 ; i++ )
   {
      blit ( buffer, buffer, 0, 3, 0, 0, 640, 476 );
      vsync ();
      blit ( buffer, screen, 0, 0, 0, 0, 640, 480 );
      rest(1);
   }

// Credits

   for ( j = 0 ; j < 2 ; j++ )
   {
      switch ( j )
      {
         case 0 :
         textout_centre ( textbmp, FNT_ambrosia24, "Wizardry Legacy Credits",
            180, 480, General_COLOR_TEXT );
         break;
         case 1 :
         break;
      }
      
      for ( i = 0 ; i < 24 ; i++ )
      {
         blit ( textbmp, textbmp, 0, 1, 0, 0, 360, 510 );
         vsync ();
         blit ( textbmp, screen, 0, 0, 140, 0, 360, 480 );
         rest(5);
      }
   }


   textptr = wizcredits;
   nomoretext = false;
   while ( nomoretext == false )
   {
      // copy text
      i = 0;
      while ( *textptr != '\n' && i < 40 )
      {
         if ( *textptr != '\n' && *textptr != '\r' )
         {
            textline [ i ] = *textptr;
            i++;
         }
         textptr++;

      }
      textline [ i ] = '\0';
      textptr++;

      // check for code
      if ( strcmp ( textline, "<ENDCREDITS>" ) == 0 )
         nomoretext = true;

      if ( nomoretext == false )
      {
         textout ( textbmp, FNT_helvetica22, textline, 0, 480, General_COLOR_TEXT );
         for ( i = 0 ; i < 24 ; i++ )
         {

            blit ( textbmp, textbmp, 0, 1, 0, 0, 360, 510 );
            vsync ();
            blit ( textbmp, screen, 0, 0, 140, 0, 360, 480 );
            rest(5);
         }
      }
   }

   for ( j = 0 ; j < 3 ; j++ )
   {
      switch ( j )
      {
         case 0 :
         textout_centre ( textbmp, FNT_helena24, p_adventurename, 180, 480, General_COLOR_TEXT );
         break;
         case 1 :
         textout_centre ( textbmp, FNT_helena24, "Credits", 180, 480, General_COLOR_TEXT );
         break;
         case 2 :
         break;
      }
      
      for ( i = 0 ; i < 24 ; i++ )
      {
         blit ( textbmp, textbmp, 0, 1, 0, 0, 360, 510 );
         vsync ();
         blit ( textbmp, screen, 0, 0, 140, 0, 360, 480 );
         rest(5);
      }
   }

   textptr = TXT_acredits;
   nomoretext = false;
   while ( nomoretext == false )
   {
      // copy text
      i = 0;
      while ( *textptr != '\n' && i < 40 )
      {
         if ( *textptr != '\n' && *textptr != '\r' )
         {
            textline [ i ] = *textptr;
            i++;
         }
         textptr++;

      }
      textline [ i ] = '\0';
      textptr++;

      // check for code
      if ( strcmp ( textline, "<ENDCREDITS>" ) == 0 )
         nomoretext = true;

      if ( nomoretext == false )
      {
         textout ( textbmp, FNT_helvetica22, textline, 0, 480, General_COLOR_TEXT );
         for ( i = 0 ; i < 24 ; i++ )
         {

            blit ( textbmp, textbmp, 0, 1, 0, 0, 360, 510 );
            vsync ();
            blit ( textbmp, screen, 0, 0, 140, 0, 360, 480 );
            rest(5);
         }
      }
   }

   // scrool rest

   for ( i = 0 ; i < 48 ; i++ )
   {
       blit ( textbmp, textbmp, 0, 1, 0, 0, 360, 510 );
       vsync ();
       blit ( textbmp, screen, 0, 0, 140, 0, 360, 480 );
       rest(5);
   }


   textout ( textbmp, FNT_freehand24, "And please worship the Vorpal Bunnies" , 0, 480, General_COLOR_TEXT );
   for ( i = 0 ; i < 510 ; i++ )
   {
      blit ( textbmp, textbmp, 0, 1, 0, 0, 360, 510 );
      vsync ();
      blit ( textbmp, screen, 0, 0, 140, 0, 360, 480 );
      rest ( 5 );
   }

   clear_bitmap ( screen );
   clear_bitmap ( buffer );

   rest ( 2000 );

   BITMAP *thend = create_bitmap ( 320, 50 );

   clear_to_color ( thend, makecol ( 255, 0, 255 ) );
   
   textout_centre ( thend, FNT_elgar32, "T h e    E n d", 160, 10,
      makecol ( 250, 150, 150 ) );

   for ( i = 3 ; i < 256 ; i = i + 4 )
   {
      set_trans_blender ( 0, 0, 0, i );
      draw_trans_sprite ( buffer, thend, 160, 215 );
      copy_buffer();
   }

   rest ( 5000 );

   for ( i = 255 ; i > 0 ; i = i - 4 )
   {
      set_trans_blender ( 0, 0, 0, i );
      draw_trans_sprite ( buffer, thend, 160, 215 );
      copy_buffer();
   }

   rest ( 2000 );

   destroy_bitmap ( textbmp );
   destroy_bitmap ( buf1 );
   destroy_bitmap ( buf2 );
   destroy_bitmap ( thend );
   
}


/*-------------------------------------------------------------------------*/
/*-                         Virtual Methods                               -*/
/*-------------------------------------------------------------------------*/

void Adventure::objdat_to_strdat ( void *dataptr )
{
   dbs_Adventure &tmpdat = *(static_cast<dbs_Adventure*> ( dataptr ));

   strncpy ( tmpdat.saganame, p_saganame, 31 );
   strncpy ( tmpdat.adventurename, p_adventurename, 31 );
//   strncpy ( tmpdat.saganame, p_saganame, 31 );
   tmpdat.episode = p_episode;
   strncpy ( tmpdat.authorname, p_authorname, 21 );
   strncpy ( tmpdat.version, p_version, 11 );
   strncpy ( tmpdat.date, p_date, 26 );
   strncpy ( tmpdat.impassword, p_import_password, 9 );
   strncpy ( tmpdat.expassword, p_export_password, 9 );
   strncpy ( tmpdat.filename, p_filename, 23 );
}

void Adventure::strdat_to_objdat ( void *dataptr )
{
   dbs_Adventure &tmpdat = *(static_cast<dbs_Adventure*> ( dataptr ));

   strcpy ( p_saganame, tmpdat.saganame );
   strcpy ( p_adventurename, tmpdat.adventurename );
   p_episode = tmpdat.episode;
   strcpy ( p_authorname, tmpdat.authorname );
   strcpy ( p_version, tmpdat.version );
   strcpy ( p_date, tmpdat.date );
   strcpy ( p_import_password, tmpdat.impassword );
   strcpy ( p_export_password, tmpdat.expassword );
   strcpy ( p_filename, tmpdat.filename );

      /*   char saganame [ 31 ] a_packed;
   char adventurename [ 31 ] a_packed;
   tiny episode a_packed;
   char authorname [ 21 ] a_packed;
   char version [ 11 ] a_packed;
   char date [ 26 ] a_packed;
   char impassword [ 9 ] a_packed;
   char expassword [ 9 ] a_packed;
   char filename [ 23 ] a_packed;
*/

}

void Adventure::child_DBremove ( void )
{
   dword index;
   Game tmpgame;

   index = db.search_table_entry ( DBTABLE_GAME );

   while ( db.entry_table_tag ( index ) == DBTABLE_GAME )
   {
      tmpgame.DBselect ( index );

      if ( tmpgame.adventure() == p_reftag )
         tmpgame.DBremove ();
      index++;
   }
}




