/***************************************************************************/
/*                                                                         */
/*                        A C C O U N T . C P P                            */
/*                         Class Source Code                               */
/*                                                                         */
/*     Content : Class Account                                             */
/*     Programmer : Eric Pietrocupo                                        */
/*     Starting Date : July 24th, 2003                                     */
/*     License : GNU General Public License                                */
/*                                                                         */
/***************************************************************************/

#include <general.h>
//#include <stdio.h>
//#include <stdlib.h>
//#include <time.h>
#include <allegro.h>
#include <string.h>
//#include <datafile.h>
#include <advdatf.h>
#include <datmacro.h>
#include <system.h>
//#include <init.h>
#include <menu.h>
//#include <option.h>
//#include <screen.h>
//#include <dbdata.h>
//#include <dbtag.h>
//#include <database.h>
//#include <dbobject.h>
#include <ddt.h>
#include <dbdef.h>
#include <item.h>
#include <armor.h>
#include <weapon.h>
#include <shield.h>
#include <accesory.h>
#include <expandbl.h>
#include <list.h>
#include <race.h>
#include <opponent.h>
#include <charactr.h>
//#include <monster.h>
#include <party.h>
#include <player.h>
#include <adventur.h>
#include <account.h>
#include <game.h>
#include <manager.h>
//#include <city.h>
#include <maze.h>
//#include <adventur.h>
//#include <camp.h>
//#include <config.h>
//#include <draw.h>
//#include <dialog.h>
//#include <combat.h>
#include <window.h>
#include <winmenu.h>
#include <winlist.h>
#include <winempty.h>
#include <wintitle.h>
//#include <windata.h>
//#include <wdatproc.h>
#include <winmessa.h>
#include <winquest.h>
#include <wininput.h>
#include <strmake.h>

/*-------------------------------------------------------------------------*/
/*-                   Constructor and Destructor                          -*/
/*-------------------------------------------------------------------------*/


Account::Account ( void )
{
   strcpy ( p_name,"" );
   strcpy ( p_family,"" );
   strcpy ( p_nickname, "" );
   strcpy ( p_loginame, "" );
   strcpy ( p_password, "" );
   p_nb_login = 0;

   p_dblength = sizeof ( dbs_Account );
   p_dbtableID = DBTABLE_ACCOUNT;
   
}
Account::~Account ( void )
{

}


/*-------------------------------------------------------------------------*/
/*-                          Property Methods                             -*/
/*-------------------------------------------------------------------------*/

/*string& Account::name ( void )
{
   return ( p_name );
} */
const char* Account::name ( void )
{
   return ( p_name );
}
void Account::name ( const char *str )
{
   strncpy ( p_name, str, 16 );
}
/*string& Account::family ( void )
{
   return ( p_family );
} */
const char* Account::family ( void )
{
   return ( p_family );
}
void Account::family ( const char *str )
{
   strncpy ( p_family, str, 16 );
}
/*string& Account::nickname ( void )
{
   return ( p_nickname );
} */
const char* Account::nickname ( void )
{
   return ( p_nickname );
}
void Account::nickname ( const char *str )
{
   strncpy ( p_nickname, str, 16 );
}
/*string& Account::loginame ( void )
{
   return ( p_loginame );
} */
const char* Account::loginame ( void )
{
   return ( p_loginame );
}
void Account::loginame ( const char *str )
{
   strncpy ( p_loginame, str, 11 );
}
void Account::password ( const char *str )
{
   strncpy ( p_password, str, 11 );
}

DBTag Account::selected_player ( void )
{
   return ( p_selected_player );
}

/*-------------------------------------------------------------------------*/
/*-                           Methods                                     -*/
/*-------------------------------------------------------------------------*/

tiny Account::start ( void )
{
   Menu mnu_account ("Account's Options");;
   short answer = 0;
   tiny retval = Account_CONTINUE;

   mnu_account.add_item ("Join a Game");
   mnu_account.add_item ("Retire from a game");
   mnu_account.add_item ("Logout");

   play_music_track ( System_MUSIC_w3city );

   WinEmpty wemp_background;
   WinTitle wttl_title ("User's Account");

   while ( answer != -1 && retval == Account_CONTINUE )
   {
      WinMenu wmnu_account ( mnu_account, 20, 40, true );

      answer = Window::show_all();

      wmnu_account.hide();
      switch ( answer )
      {
         case Account_MENU_JOIN :
            retval = show_join_game();
         break;
         case Account_MENU_RETIRE :
            show_retire_game();
         break;
         case Account_MENU_LOGOUT :
            retval = Account_EXIT;
            db.default_source ( DBSOURCE_SYSTEM );
         break;
      }

   }
  
   return ( retval );
}

bool Account::verify_password ( const char *str )
{
   if ( strcmp ( p_password, str ) == 0 )
      return ( true );
   else
      return ( false );
}

/*-------------------------------------------------------------------------*/
/*-                          Property Methods                             -*/
/*-------------------------------------------------------------------------*/

tiny Account::show_join_game ( void )
{
   tiny retval = Account_CONTINUE;
   List lst_game ("Select an Game to JOIN", 22);
   Game tmpgame;
   Adventure tmpadv;
   dword i = db.search_table_entry ( DBTABLE_GAME );
   dword copyindex [ Manager_NB_MAX_GAME ];   
//   string tmpstr;
   char strgamelst [ 81 ];
   char strpasswd [ 11 ];
   short answer = 0;
   short answer2 = 0;
   dword j = 0;
   Player tmplayer;
   DBTag acctag;
   DBTag gametag;
   DBTag tmptag;
   bool player_found;
   bool pass = false;

   do
   {
//      db.entry_table_tag ( i ) == DBTABLE_GAME
      tmpgame.DBselect ( i );
      strmake_game_list ( tmpgame, strgamelst );
      lst_game.add_item ( strgamelst );
      copyindex [ j ] = i;
      i++;
      j++;
   }
   while ( db.entry_table_tag ( i ) == DBTABLE_GAME );

   WinList wlst_game ( lst_game, 20, 40 );
   while ( answer != -1 && retval != Account_JOIN )
   {
      wlst_game.unhide();
      Window::instruction ( 320, 460 );
      answer = Window::show_all();

      wlst_game.hide();
      if ( answer != -1 )
      {
         acctag = p_reftag;
         gametag = db.get_tag ( copyindex [ answer ] );
         tmpgame.DBselect ( copyindex [ answer ] );
         pass = false;

         if ( tmpgame.pass_protect() == true )
         {
            WinInput winp_password ("This game is protected, enter the password?", 10, 200, 100 );
            Window::show_all();
            winp_password.get_string( strpasswd );

            if ( tmpgame.verify_password ( strpasswd ) )
               pass = true;
            else
            {
               WinMessage wmsg_error ("Password Incorrect!");
               Window::show_all();
            }
         }
         else
            pass = true;
         
         if ( pass == true )
         {
//            tmpstr = "savegame\\";

/*            if ( exists ( tmpstr.data() ) == true )
               textprintf ( buffer, font, 0, 0, General_COLOR_TEXT,
                  "%s exist", tmpstr.data() );
            else
               textprintf ( buffer, font, 0, 0, General_COLOR_TEXT,
                  "%s does not exist", tmpstr.data() );

            copy_buffer();
            while ( ( readkey() >> 8 ) != KEY_ENTER ); */
            
            db.load_dba_file ( tmpgame.savegame(), DBSOURCE_SAVEGAME );
            Character::levelup_speed ( tmpgame.levelup() );

            player_found = false;
            i = db.search_table_entry ( DBTABLE_PLAYER );
            while ( db.entry_table_tag ( i ) == DBTABLE_PLAYER
               && player_found == false )
            {
               tmplayer.DBselect ( i );
               tmptag = tmplayer.account();
               if ( tmptag.number() == acctag.number() )
                  player_found = true;
               else
                  i++;
            }

            if ( player_found == true )
            {
               p_selected_player = tmplayer.tag();
               retval = Account_JOIN;

               //!! this code is duplicated a dozen of lines below !!
               WinTitle wttl_loading ("Loading Adventure", 320, 200 );
               Window::draw_all();
               copy_buffer();

               tmpadv.DBselect ( tmpgame.adventure() );
               adatf = load_datafile ( tmpadv.filename () );
               maze.reference_adv_bitmap();
               db.load_dba_from_dat ( DBA_adatabase , DBSOURCE_ADVENTURE );
            }
            else
            {
               WinQuestion wqst_newplayer ("You do not possess any player in this game.\nDo you want to create a new one ?");
               answer2 = Window::show_all();
               wqst_newplayer.hide();

               if ( answer2 == 0 )
               {
                  Player newplayer;
                  newplayer.game ( gametag );
                  newplayer.account ( acctag );
                  p_selected_player = newplayer.DBinsert();
                  retval = Account_JOIN;
                  
                  //!! this code is duplicated a dozen of lines above !!
                  WinTitle wttl_loading ("Loading Adventure", 320, 200 );
                  Window::draw_all();
                  copy_buffer();

                  tmpadv.DBselect ( tmpgame.adventure() );
                  adatf = load_datafile ( tmpadv.filename () );
//                  textout ( screen, font, "adatf Loading done", 10, 20, General_COLOR_TEXT );
                  maze.reference_adv_bitmap();
//                  textout ( screen, font, "BMP_REFERENCED", 10, 40, General_COLOR_TEXT );
                  db.load_dba_from_dat ( DBA_adatabase , DBSOURCE_ADVENTURE );
//                  textout ( screen, font, "DB Loaded", 10, 60, General_COLOR_TEXT );

/*                  dword index = 0;
                  DBTag tmptag;
                  short y = 0;
                  
                  while ( index < db.nb_entry() )
                  {

                     tmptag = db.get_tag ( index );
                     if ( tmptag.table() >= 10 )
                     {

                        textprintf ( buffer, font, 0, y, General_COLOR_TEXT,
                           "%6d : %2d : %1d : %5d : %d Bytes", index,
                           tmptag.table(), tmptag.source(), tmptag.key(),
                           db.entry_length ( index ) );
                        y = y + 16;
                     }
                     index++;
                  }

                  copy_buffer();                  
                  while ( ( readkey() >> 8 ) != KEY_ENTER );*/


                  newplayer.select_default_city();
                  newplayer.DBupdate();
//                  textout ( screen, font, "Starting Intro", 10, 80, General_COLOR_TEXT );
                  tmpadv.show_intro();
                  
               }
               else
                  db.remove_source ( DBSOURCE_SAVEGAME );
            }
         }
      }
   }

   return ( retval );
}

/*void Account::show_continue_game ( void )
{

} */

void Account::show_retire_game ( void )
{
   short answer = 0;
   short answer2 = 0;
   dword index;
   dword playerindex;
//   string tmpstr;
   char strgamelst [ 81 ];
   Game tmpgame;
   Player tmplayer;
//   dbs_Player splayer;
   dword copyindex [ Manager_NB_MAX_GAME ];
   dword j;
   bool found;
   DBTag tmptag;
   bool nomoregame = false;
//   Player tmplayer;

   while ( answer != -1 && nomoregame == false )
   {
      // make list of played games
      List lst_game ("Select a game to RETIRE", 22 );
      Window::instruction ( 320, 460 );
      index = db.search_table_entry ( DBTABLE_GAME );

      j =0;
      while ( db.entry_table_tag ( index ) == DBTABLE_GAME )
      {
         tmpgame.DBselect ( index );
         Database tmpdatb;

         tmpdatb.load_dba_file ( tmpgame.savegame(), DBSOURCE_SAVEGAME );

         playerindex = tmpdatb.search_table_entry ( DBTABLE_PLAYER );

         found = false;
         while ( tmpdatb.entry_table_tag( playerindex ) == DBTABLE_PLAYER
            && found == false )
         {
            tmplayer.exDBselect ( tmpdatb, playerindex );

            tmptag = tmplayer.account();
            if ( tmptag == p_reftag )
            {
               tmplayer.exDBremove ( tmpdatb );
               found = true;
               strmake_game_list ( tmpgame, strgamelst );
               lst_game.add_item ( strgamelst );
               copyindex [ j ] = index;
               j++;
            }
         }
         index++;
      }

      if ( j == 0 )
         nomoregame = true;

      // interpret results
      if ( nomoregame == false )
      {
        WinList wlst_game ( lst_game, 20, 40 );
        answer = Window::show_all();
      }

      if ( answer != -1 && nomoregame == false )
      {
         WinQuestion wqst_confirm ("Are you sure you want to retire from this game?");
         answer2 = Window::show_all();

         if ( answer2 == 0 )
         {
            Database tmpdatb;
            tmpgame.DBselect ( copyindex [ answer ] );

            tmpdatb.load_dba_file ( tmpgame.savegame(), DBSOURCE_SAVEGAME );

            playerindex = tmpdatb.search_table_entry ( DBTABLE_PLAYER );

            found = false;
            while ( tmpdatb.entry_table_tag( playerindex ) == DBTABLE_PLAYER
               && found == false )
            {
               tmplayer.exDBselect ( tmpdatb, playerindex );

               tmptag = tmplayer.account();
               if ( tmptag == p_reftag )
               {
                  tmplayer.exDBremove ( tmpdatb );
                  found = true;
                  if ( j == 1 )
                     nomoregame = true;
               }
            }
            tmpdatb.save_dba_file ( tmpgame.savegame(), DBSOURCE_SAVEGAME );
         }
      }
   }
}


/*-------------------------------------------------------------------------*/
/*-                        Virtual Methods                                -*/
/*-------------------------------------------------------------------------*/

/*
DBTag Account::DBinsert ( void )
{
   dbs_Account tmpdat;
   DBTag tmptag;
//   tiny i;

   strncpy ( tmpdat.name, p_name, 15 );
   strncpy ( tmpdat.family, p_family, 15 );
   strncpy ( tmpdat.nickname, p_nickname, 15 );
   strncpy ( tmpdat.loginame, p_loginame, 10 );
   strncpy ( tmpdat.password, p_password, 10 );
   tmpdat.nb_login = p_nb_login;

   tmptag = db.insert ( DBTABLE_ACCOUNT,
      static_cast<void*>(&tmpdat), sizeof ( dbs_Account ) );
   end_insert ( tmptag );

   return ( tmptag );
}

void Account::DBupdate ( void )
{
   if ( p_readonly == false )
   {
      dbs_Account tmpdat;

      strncpy ( tmpdat.name, p_name, 15 );
      strncpy ( tmpdat.family, p_family, 15 );
      strncpy ( tmpdat.nickname, p_nickname, 15 );
      strncpy ( tmpdat.loginame, p_loginame, 10 );
      strncpy ( tmpdat.password, p_password, 10 );
      tmpdat.nb_login = p_nb_login;

      db.update ( p_reftag,
         static_cast<void*>(&tmpdat), sizeof ( dbs_Account ) );
      end_update();
   }

}

void Account::DBselect ( DBTag value, bool readonly )
{
   dbs_Account tmpdat;
   if ( db.select ( &tmpdat, value, sizeof ( dbs_Account ) ) == true )
   {

      p_name = tmpdat.name;
      p_family = tmpdat.family;
      p_nickname = tmpdat.nickname;
      p_loginame = tmpdat.loginame;
      p_password = tmpdat.password;
      p_nb_login = tmpdat.nb_login;
   
      end_select ( value, readonly );
   }
}

void Account::DBselect ( dword index, bool readonly )
{
   dbs_Account tmpdat;
   if ( db.select ( &tmpdat, index, sizeof ( dbs_Account ) ) == true )
   {
      p_name = tmpdat.name;
      p_family = tmpdat.family;
      p_nickname = tmpdat.nickname;
      p_loginame = tmpdat.loginame;
      p_password = tmpdat.password;
      p_nb_login = tmpdat.nb_login;
   
      end_select ( db.get_tag ( index ), readonly );
   }
}

void Account::DBremove ( void )
{
   dword index;
   dword playerindex;
   Game tmpgame;
   Player tmplayer;

   index = db.search_table_entry ( DBTABLE_GAME );

   while ( db.entry_table_tag ( index ) == DBTABLE_GAME )
   {
      tmpgame.DBselect ( index );
      Database tmpdatb;

      tmpdatb.load_dba_file ( tmpgame.savegame(), DBSOURCE_SAVEGAME );
      playerindex = tmpdatb.search_table_entry ( DBTABLE_PLAYER );

      while ( tmpdatb.entry_table_tag( playerindex ) == DBTABLE_PLAYER )
      {
         tmplayer.exDBselect ( tmpdatb, playerindex );

         if ( tmplayer.account() == p_reftag )
            tmplayer.exDBremove ( tmpdatb );
      }
      
      tmpdatb.save_dba_file ( tmpgame.savegame(), DBSOURCE_SAVEGAME );
      index++;
   }

   db.remove ( p_reftag );
   end_remove();
}*/

void Account::objdat_to_strdat ( void *dataptr )
{
   dbs_Account &tmpdat = *(static_cast<dbs_Account*> ( dataptr ));

   strncpy ( tmpdat.name, p_name, 16 );
   strncpy ( tmpdat.family, p_family, 16 );
   strncpy ( tmpdat.nickname, p_nickname, 16 );
   strncpy ( tmpdat.loginame, p_loginame, 11 );
   strncpy ( tmpdat.password, p_password, 11 );
   tmpdat.nb_login = p_nb_login;
   
}

void Account::strdat_to_objdat ( void *dataptr )
{
   dbs_Account &tmpdat = *(static_cast<dbs_Account*> ( dataptr ));

   strncpy ( p_name, tmpdat.name, 16 );
   strncpy ( p_family, tmpdat.family, 16 );
   strncpy ( p_nickname, tmpdat.nickname, 16 );
   strncpy ( p_loginame, tmpdat.loginame, 11 );
   strncpy ( p_password, tmpdat.password, 11 );
   p_nb_login = tmpdat.nb_login;
   
}

void Account::child_DBremove ( void )
{
   dword index;
   dword playerindex;
   Game tmpgame;
   Player tmplayer;
   DBTag removelist [ Manager_NB_MAX_GAME ];
   short removeindex;
   short i;

   index = db.search_table_entry ( DBTABLE_GAME );

   while ( db.entry_table_tag ( index ) == DBTABLE_GAME )
   {
      tmpgame.DBselect ( index );
      Database tmpdatb;

      tmpdatb.load_dba_file ( tmpgame.savegame(), DBSOURCE_SAVEGAME );
      playerindex = tmpdatb.search_table_entry ( DBTABLE_PLAYER );

      removeindex = 0;
      while ( tmpdatb.entry_table_tag( playerindex ) == DBTABLE_PLAYER )
      {
         tmplayer.exDBselect ( tmpdatb, playerindex );

         if ( tmplayer.account() == p_reftag )
         {
            removelist [ removeindex ] = tmplayer.tag();
            removeindex++;
         }
      }

      for ( i = 0 ; i < removeindex ; i++ )
      {
         tmplayer.exDBselect ( tmpdatb, removelist [ i ] );

         if ( tmplayer.account() == p_reftag )
            tmplayer.exDBremove ( tmpdatb );
      }
      
      tmpdatb.save_dba_file ( tmpgame.savegame(), DBSOURCE_SAVEGAME );
      index++;
   }

}




