/**************************************************************************/
/*                     Audio Sample/Music demo Programm                   */
/*                           By Eric Pietrocupo                           */
/**************************************************************************/
#include <allegro.h>
#include <stdio.h>

int main ( void )
{
   SAMPLE* smp_test;
   MIDI* mid_test;
   int key;

   allegro_init();
   detect_digi_driver(DIGI_AUTODETECT);
   detect_midi_driver(MIDI_AUTODETECT);
   
   install_keyboard();
   install_timer();
   install_sound(DIGI_AUTODETECT,MIDI_AUTODETECT, NULL);

   smp_test = load_sample ("bad.wav");
   mid_test = load_midi ("w2fight.mid");

   printf ("Press ENTER to end or SPACE to play Sample\n"); // note that we
      // are currently not in graphic mode so using printf is OK

   play_midi ( mid_test, 1 );

   key = KEY_ESC;
   while ( key != KEY_ENTER )
   {
      key= readkey () >> 8;
      if ( key == KEY_SPACE )
         play_sample(smp_test, 200, 128, 1000, 0 );
   }
 
   allegro_exit();
   return (0);
}
END_OF_MAIN();
